/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.utilities;

public class GraphLabels {
    public static void drawTicks(double min, double max, int nticks, DrawCallback dcb) {
        double range = GraphLabels.niceNum(max - min, false);
        double d = GraphLabels.niceNum(range / (double)(nticks - 1), true);
        double graphMin = Math.floor(min / d) * d;
        double graphMax = Math.ceil(max / d) * d;
        int nfrac = (int)Math.max(-Math.floor(Math.log10(d)), 0.0);
        for (double x = graphMin; x < graphMax + 0.5 * d; x += d) {
            dcb.draw(x, nfrac);
        }
    }

    public static double niceNum(double x, boolean round) {
        long exp = (long)Math.floor(Math.log10(x));
        double f = x / Math.pow(10.0, exp);
        double nf = round ? (f < 1.5 ? 1.0 : (f < 3.0 ? 2.0 : (f < 7.0 ? 5.0 : 10.0))) : (f <= 1.0 ? 1.0 : (f <= 2.0 ? 2.0 : (f <= 5.0 ? 5.0 : 10.0)));
        return nf * Math.pow(10.0, exp);
    }

    public static interface DrawCallback {
        public void draw(double var1, int var3);
    }
}

