/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.utilities.audio;

import blue.ui.utilities.audio.AudioWaveformCache;
import blue.ui.utilities.audio.AudioWaveformData;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.SwingUtilities;

public class AudioWaveformCacheGenerator
extends Thread {
    public static final String CACHE_GEN_COMPLETE = "CACHE_GEN_COMPLETE";
    List<AudioWaveformData> workQueue = Collections.synchronizedList(new ArrayList());
    boolean running = true;
    boolean killed = false;
    private final AudioWaveformCache audioWaveformCache;

    public AudioWaveformCacheGenerator(AudioWaveformCache audioWaveformCache) {
        this.audioWaveformCache = audioWaveformCache;
    }

    public void addAudioWaveformData(AudioWaveformData audioWaveformData) {
        this.workQueue.add(audioWaveformData);
    }

    public int getPixelSeconds() {
        if (this.workQueue.isEmpty()) {
            return -1;
        }
        return this.workQueue.get((int)0).pixelSeconds;
    }

    @Override
    public void run() {
        while (this.running && this.workQueue.size() > 0) {
            AudioWaveformData data = this.workQueue.get(0);
            this.analyzeWaveform(data);
            this.audioWaveformCache.fireAudioWaveformDataGenerated(data.fileName);
            if (this.running) {
                this.workQueue.remove(0);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        if (!this.killed) {
            this.audioWaveformCache.fireAudioWaveformDataGenerated(CACHE_GEN_COMPLETE);
        }
        this.running = false;
    }

    public void killRunning() {
        this.running = false;
        this.killed = true;
        this.interrupt();
        this.workQueue.clear();
    }

    public boolean isRunning() {
        return this.running;
    }

    private void analyzeWaveform(AudioWaveformData waveData) {
        try {
            File f = new File(waveData.fileName);
            AudioFileFormat aFormat = AudioSystem.getAudioFileFormat(f);
            AudioFormat format = aFormat.getFormat();
            int numChannels = format.getChannels();
            try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(new FileInputStream(f)));){
                int sr = (int)format.getSampleRate();
                int numBytesPerSample = audioInputStream.getFormat().getSampleSizeInBits() / 8;
                int numFramesToRead = sr / waveData.pixelSeconds;
                boolean bigEndian = format.isBigEndian();
                int len = format.getFrameSize() * numFramesToRead;
                byte[] dataBuffer = new byte[len];
                int maxWidth = aFormat.getFrameLength() / numFramesToRead + 1;
                waveData.data = new double[numChannels][maxWidth * 2];
                for (int i = 0; i < maxWidth && this.running; ++i) {
                    int numRead = audioInputStream.read(dataBuffer, 0, len);
                    if (numRead <= 0) {
                        waveData.percentLoadingComplete = 1.0;
                        break;
                    }
                    waveData.percentLoadingComplete = i / maxWidth;
                    if (i % 100 == 0) {
                        SwingUtilities.invokeLater(() -> this.audioWaveformCache.fireAudioWaveformDataGenerated(waveData.fileName));
                    }
                    this.prepareSamples(waveData, dataBuffer, i, numChannels, numBytesPerSample, bigEndian);
                }
                waveData.percentLoadingComplete = 1.0;
            }
        }
        catch (IOException | UnsupportedAudioFileException e) {
            waveData.data = null;
            e.printStackTrace();
        }
    }

    private void prepareSamples(AudioWaveformData waveForm, byte[] dataBuffer, int pixelNum, int numChannels, int numBytesPerSample, boolean bigEndian) {
        int i;
        int frameSize = numChannels * numBytesPerSample;
        int scaleValue = 256;
        for (i = 1; i < numBytesPerSample; ++i) {
            scaleValue *= 256;
        }
        scaleValue /= 2;
        for (i = 0; i < numChannels; ++i) {
            int offset = i * numBytesPerSample;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (int j = 0; j < dataBuffer.length / frameSize; ++j) {
                int index = j * frameSize + offset;
                int val = this.getValue(dataBuffer, index, numBytesPerSample, bigEndian);
                if (val < min) {
                    min = val;
                }
                if (val <= max) continue;
                max = val;
            }
            double minY = (double)min / (double)scaleValue;
            double maxY = (double)max / (double)scaleValue;
            waveForm.data[i][pixelNum * 2] = minY;
            waveForm.data[i][pixelNum * 2 + 1] = maxY;
        }
    }

    private int getValue(byte[] dataBuffer, int offset, int numBytesPerSample, boolean bigEndian) {
        int value = 0;
        if (bigEndian) {
            int max = numBytesPerSample - 1;
            for (int i = 0; i < numBytesPerSample; ++i) {
                byte temp = dataBuffer[offset + i];
                int shiftVal = (max - i) * 8;
                value += temp << shiftVal;
            }
        } else {
            for (int i = 0; i < numBytesPerSample; ++i) {
                byte temp = dataBuffer[offset + i];
                int shiftVal = i * 8;
                value += temp << shiftVal;
            }
        }
        return value;
    }
}

