/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.utilities.audio;

import blue.ui.utilities.audio.AudioWaveformData;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class AudioWaveformUI {
    public static void paintWaveForm(Graphics2D g, int sObjVisibleHeight, AudioWaveformData waveForm, int audioFileStartIndex) {
        if (waveForm.data == null) {
            return;
        }
        Rectangle bounds = g.getClipBounds();
        int startX = bounds.x;
        int endX = startX + bounds.width;
        if (startX < 0) {
            startX = 0;
        }
        int channelHeight = sObjVisibleHeight / waveForm.data.length;
        int middleZero = channelHeight / 2;
        for (int j = 0; j < waveForm.data.length; ++j) {
            int index;
            int yAdjust = j * channelHeight;
            for (int i = startX; i < endX && (index = (i + audioFileStartIndex) * 2) + 1 <= waveForm.data[j].length; ++i) {
                int y1 = (int)((double)middleZero - waveForm.data[j][index] * (double)middleZero) + yAdjust;
                int y2 = (int)((double)middleZero - waveForm.data[j][index + 1] * (double)middleZero) + yAdjust;
                g.drawLine(i, y1, i, y2);
            }
        }
    }
}

