/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.openide.filesystems.FileObject;

public class EditorLocatorFactory
implements SettingsType.LocatorFactory {
    private static final Logger LOG = Logger.getLogger(EditorLocatorFactory.class.getName());

    public SettingsType.Locator createLocator(StorageDescription sd) {
        if ("FontsColors".equals(sd.getId())) {
            return new FontsColorsLocator(sd.getId(), sd.isUsingProfiles(), sd.getMimeType(), sd.getLegacyFileName());
        }
        if ("Keybindings".equals(sd.getId())) {
            return new LegacyTextBaseLocator(sd.getId(), sd.isUsingProfiles(), sd.getMimeType(), sd.getLegacyFileName());
        }
        return null;
    }

    private static final class FontsColorsLocator
    extends SettingsType.DefaultLocator {
        private static final String[] M_LEGACY_FILE_NAMES = new String[]{"Defaults/defaultColoring.xml", "Defaults/coloring.xml", "Defaults/editorColoring.xml"};
        private static final String[] U_LEGACY_FILE_NAMES = new String[]{"defaultColoring.xml", "coloring.xml", "editorColoring.xml"};

        public FontsColorsLocator(String settingTypeId, boolean hasProfiles, String mimeType, String legacyFileName) {
            super(settingTypeId, hasProfiles, mimeType, legacyFileName);
        }

        protected void addModulesLegacyFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            this.addFiles(mimeFolder, profileId, fullScan, M_LEGACY_FILE_NAMES, files, true);
        }

        protected void addUsersLegacyFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            this.addFiles(mimeFolder, profileId, fullScan, U_LEGACY_FILE_NAMES, files, false);
        }

        private void addFiles(FileObject mimeFolder, String profileId, boolean fullScan, String[] filePaths, Map<String, List<Object[]>> files, boolean moduleFiles) {
            if (profileId == null) {
                FileObject[] profileHomes;
                for (FileObject f : profileHomes = mimeFolder.getChildren()) {
                    if (!f.isFolder()) continue;
                    String id = f.getNameExt();
                    this.addFiles(f, filePaths, fullScan, files, id, f, moduleFiles);
                }
            } else {
                FileObject profileHome = mimeFolder.getFileObject(profileId);
                if (profileHome != null && profileHome.isFolder()) {
                    this.addFiles(profileHome, filePaths, fullScan, files, profileId, profileHome, moduleFiles);
                }
            }
        }

        private void addFiles(FileObject folder, String[] filePaths, boolean fullScan, Map<String, List<Object[]>> files, String profileId, FileObject profileHome, boolean moduleFiles) {
            for (String filePath : filePaths) {
                FileObject f = folder.getFileObject(filePath);
                if (f == null) continue;
                List<Object[]> pair = files.get(profileId);
                if (pair == null) {
                    pair = new ArrayList<Object[]>();
                    files.put(profileId, pair);
                }
                pair.add(new Object[]{profileHome, f, moduleFiles, null, true});
                if (LOG.isLoggable(Level.INFO)) {
                    Utils.logOnce((Logger)LOG, (Level)Level.INFO, (String)(this.settingTypeId + " settings " + "should reside in '" + this.settingTypeId + "' subfolder, " + "see #90403 for details. Offending file '" + f.getPath() + "'"), null);
                }
                if (!fullScan) break;
            }
        }
    }

    private static final class LegacyTextBaseLocator
    extends SettingsType.DefaultLocator {
        public LegacyTextBaseLocator(String settingTypeId, boolean hasProfiles, String mimeType, String legacyFileName) {
            super(settingTypeId, hasProfiles, mimeType, legacyFileName);
        }

        protected FileObject getLegacyMimeFolder(FileObject baseFolder, String mimeType) {
            if (mimeType == null || mimeType.length() == 0) {
                return baseFolder.getFileObject("text/base");
            }
            return super.getMimeFolder(baseFolder, mimeType);
        }
    }
}

