/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.clojure;

import blue.ui.editor.clojure.ClojureTokenId;
import blue.ui.editor.clojure.antlr.ClojureLexer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openide.util.Exceptions;

public class AntlrTokenReader {
    private HashMap<String, String> tokenTypes = new HashMap();
    private ArrayList<ClojureTokenId> tokens = new ArrayList();

    public AntlrTokenReader() {
        this.init();
    }

    private void init() {
        this.tokenTypes.put("AMPERSAND", "keyword");
        this.tokenTypes.put("APOSTROPHE", "macro-character");
        this.tokenTypes.put("BACKSLASH", "character");
        this.tokenTypes.put("BOOLEAN", "keyword");
        this.tokenTypes.put("CHARACTER", "character");
        this.tokenTypes.put("CLOSE_PAREN", "character");
        this.tokenTypes.put("CIRCUMFLEX", "macro-character");
        this.tokenTypes.put("COMMENT", "comment");
        this.tokenTypes.put("COMMERCIAL_AT", "macro-character");
        this.tokenTypes.put("EscapeSequence", "string");
        this.tokenTypes.put("HEXDIGIT", "character");
        this.tokenTypes.put("KEYWORD", "keyword");
        this.tokenTypes.put("LAMBDA_ARG", "keyword");
        this.tokenTypes.put("LEFT_CURLY_BRACKET", "character");
        this.tokenTypes.put("LEFT_SQUARE_BRACKET", "character");
        this.tokenTypes.put("METADATA_TYPEHINT", "macro-character");
        this.tokenTypes.put("NAME", "character");
        this.tokenTypes.put("NIL", "keyword");
        this.tokenTypes.put("NUMBER", "number");
        this.tokenTypes.put("NUMBER_SIGN", "number");
        this.tokenTypes.put("OPEN_PAREN", "character");
        this.tokenTypes.put("OctalEscape", "string");
        this.tokenTypes.put("REGEX_LITERAL", "string");
        this.tokenTypes.put("RIGHT_CURLY_BRACKET", "character");
        this.tokenTypes.put("RIGHT_SQUARE_BRACKET", "character");
        this.tokenTypes.put("SPACE", "whitespace");
        this.tokenTypes.put("SPECIAL_FORM", "special");
        this.tokenTypes.put("STRING", "string");
        this.tokenTypes.put("SYMBOL", "symbol");
        this.tokenTypes.put("SYMBOL_HEAD", "symbol");
        this.tokenTypes.put("SYMBOL_REST", "symbol");
        this.tokenTypes.put("SYNTAX_QUOTE", "macro-character");
        this.tokenTypes.put("UNQUOTE", "macro-character");
        this.tokenTypes.put("UNQUOTE_SPLICING", "macro-character");
        this.tokenTypes.put("UnicodeEscape", "keyword");
    }

    public List<ClojureTokenId> readTokenFile() {
        InputStream inp = ClojureLexer.class.getResourceAsStream("Clojure.tokens");
        BufferedReader input = new BufferedReader(new InputStreamReader(inp));
        this.readTokenFile(input);
        return this.tokens;
    }

    private void readTokenFile(BufferedReader buff) {
        String line = null;
        try {
            while ((line = buff.readLine()) != null) {
                String[] splLine = line.split("=");
                String name = splLine[0];
                int tok = Integer.parseInt(splLine[1].trim());
                String tokenCategory = this.tokenTypes.get(name);
                ClojureTokenId id = tokenCategory != null ? new ClojureTokenId(name, tokenCategory, tok) : new ClojureTokenId(name, "keyword", tok);
                this.tokens.add(id);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

