/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.editor.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.python.editor.lexer.PythonCommentTokenId;
import org.netbeans.modules.python.editor.lexer.PythonLexer;
import org.netbeans.modules.python.editor.lexer.PythonStringTokenId;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.openide.filesystems.FileObject;

public enum PythonTokenId implements TokenId
{
    ERROR(null, "error"),
    IDENTIFIER(null, "identifier"),
    INT_LITERAL(null, "number"),
    FLOAT_LITERAL(null, "number"),
    STRING_LITERAL(null, "string"),
    WHITESPACE(null, "whitespace"),
    NEWLINE(null, "whitespace"),
    DECORATOR(null, "operator"),
    COMMENT(null, "comment"),
    LPAREN("(", "separator"),
    RPAREN(")", "separator"),
    LBRACE("{", "separator"),
    RBRACE("}", "separator"),
    LBRACKET("[", "separator"),
    RBRACKET("]", "separator"),
    STRING_BEGIN(null, "string"),
    STRING_END(null, "string"),
    ANY_KEYWORD(null, "keyword"),
    ANY_OPERATOR(null, "operator"),
    DEF("def", "keyword"),
    CLASS("class", "keyword"),
    IF("if", "keyword"),
    ELSE("else", "keyword"),
    ELIF("elif", "keyword"),
    RAISE("raise", "keyword"),
    PASS("pass", "keyword"),
    RETURN("return", "keyword"),
    EXCEPT("except", "keyword"),
    FINALLY("finally", "keyword"),
    IMPORT("import", "keyword"),
    FROM("from", "keyword"),
    TRY("try", "keyword"),
    DOT(".", "operator"),
    COMMA(",", "operator"),
    COLON(":", "operator"),
    ESC("\\", "operator"),
    NONUNARY_OP(null, "operator");

    private final String fixedText;
    private final String primaryCategory;
    public static final String PYTHON_MIME_TYPE = "text/x-python";
    private static final Language<PythonTokenId> language;

    private PythonTokenId(String fixedText, String primaryCategory) {
        this.fixedText = fixedText;
        this.primaryCategory = primaryCategory;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public String fixedText() {
        return this.fixedText;
    }

    public static Language<PythonTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<PythonTokenId>(){

            protected String mimeType() {
                return PythonTokenId.PYTHON_MIME_TYPE;
            }

            protected Collection<PythonTokenId> createTokenIds() {
                return EnumSet.allOf(PythonTokenId.class);
            }

            protected Map<String, Collection<PythonTokenId>> createTokenCategories() {
                HashMap<String, Collection<PythonTokenId>> cats = new HashMap<String, Collection<PythonTokenId>>();
                return cats;
            }

            protected Lexer<PythonTokenId> createLexer(LexerRestartInfo<PythonTokenId> info) {
                FileObject fileObject = (FileObject)info.getAttributeValue(FileObject.class);
                final TokenFactory tokenFactory = info.tokenFactory();
                final LexerInput input = info.input();
                if (fileObject != null && "rst".equals(fileObject.getExt())) {
                    return new Lexer<PythonTokenId>(){

                        public Token<PythonTokenId> nextToken() {
                            if (input.read() == -1) {
                                return null;
                            }
                            while (input.read() != -1) {
                            }
                            return tokenFactory.createToken((TokenId)STRING_LITERAL, input.readLength());
                        }

                        public Object state() {
                            return null;
                        }

                        public void release() {
                        }
                    };
                }
                return new PythonLexer(info);
            }

            protected LanguageEmbedding<?> embedding(Token<PythonTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                PythonTokenId id = (PythonTokenId)token.id();
                if (id == STRING_LITERAL) {
                    return LanguageEmbedding.create(PythonStringTokenId.language, (int)0, (int)0);
                }
                if (id == COMMENT) {
                    return LanguageEmbedding.create(PythonCommentTokenId.language(), (int)1, (int)0);
                }
                return null;
            }
        }.language();
    }
}

