/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.score.ScoreObject;
import blue.soundObject.CeciliaModule;
import blue.soundObject.ceciliaModule.CFileIn;
import blue.soundObject.ceciliaModule.CGraph;
import blue.soundObject.ceciliaModule.CPopup;
import blue.soundObject.ceciliaModule.CSlider;
import blue.soundObject.ceciliaModule.CToggle;
import blue.soundObject.ceciliaModule.CeciliaObject;
import blue.soundObject.ceciliaModule.ModuleDefinition;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.soundObject.editor.ceciliaModule.CeciliaModuleImportDialog;
import blue.soundObject.editor.ceciliaModule.EditorPanel;
import blue.soundObject.editor.ceciliaModule.FileInputPanel;
import blue.soundObject.editor.ceciliaModule.GrapherEditPanel;
import blue.soundObject.editor.ceciliaModule.PropertiesPanel;
import blue.utility.GUI;
import blue.utility.TextUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CeciliaModuleEditor
extends ScoreObjectEditor {
    private CeciliaModule ceciliaModule;
    private PropertiesPanel properties = new PropertiesPanel();
    private FileInputPanel fip = new FileInputPanel();
    private GrapherEditPanel grapher = new GrapherEditPanel();
    private EditorPanel editor = new EditorPanel();

    public CeciliaModuleEditor() {
        FlowLayout fLayout = new FlowLayout(0);
        JLabel label = new JLabel("[ Cecilia Module ]");
        JButton loadModule = new JButton(BlueSystem.getString((String)"ceciliaModule.loadModule"));
        loadModule.addActionListener(e -> this.loadModule());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(fLayout);
        topPanel.add(label);
        topPanel.add(loadModule);
        this.setLayout(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab(BlueSystem.getString((String)"common.properties"), this.properties);
        tabs.add(BlueSystem.getString((String)"ceciliaModule.fileInput"), this.fip);
        tabs.addTab(BlueSystem.getString((String)"ceciliaModule.grapher"), this.grapher);
        tabs.addTab(BlueSystem.getString((String)"common.editor"), this.editor);
        this.add(topPanel, "North");
        this.add(tabs, "Center");
    }

    protected void loadModule() {
        ModuleDefinition moduleDefinition = CeciliaModuleImportDialog.importCeciliaModule();
        if (moduleDefinition == null) {
            return;
        }
        HashMap stateData = this.createDefaultStateData(moduleDefinition);
        this.ceciliaModule.setModuleDefinition(moduleDefinition);
        this.ceciliaModule.setStateData(stateData);
        this.editScoreObject((ScoreObject)this.ceciliaModule);
    }

    private HashMap createDefaultStateData(ModuleDefinition moduleDefinition) {
        String tk_interface = moduleDefinition.tk_interface;
        StringTokenizer st = new StringTokenizer(tk_interface, "\n");
        HashMap<String, CeciliaObject> stateData = new HashMap<String, CeciliaObject>();
        while (st.hasMoreTokens()) {
            String[] tokens;
            String objectType;
            String line = st.nextToken().trim();
            if (line.length() == 0 || !(objectType = (tokens = TextUtilities.splitStringWithQuotes((String)line))[0]).equals("csepar") && tokens.length == 1 || objectType.equals("csepar")) continue;
            String objectName = tokens[1];
            CeciliaObject cObj = null;
            switch (objectType) {
                case "cfilein": {
                    CFileIn fileIn = new CFileIn();
                    cObj = fileIn;
                    break;
                }
                case "cpopup": {
                    CPopup popup = new CPopup();
                    cObj = popup;
                    break;
                }
                case "ctoggle": {
                    CToggle toggle = new CToggle();
                    cObj = toggle;
                    break;
                }
                case "cslider": {
                    CSlider slider = new CSlider();
                    cObj = slider;
                    break;
                }
                case "cgraph": {
                    CGraph graph = new CGraph();
                    cObj = graph;
                    break;
                }
            }
            cObj.initialize(tokens);
            stateData.put(objectName, cObj);
        }
        return stateData;
    }

    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            System.err.println("[CeciliaModuleEditor::editSoundObject()] ERROR: null object passed in");
            this.ceciliaModule = null;
            return;
        }
        if (!sObj.getClass().getName().equals("blue.soundObject.CeciliaModule")) {
            System.err.println("[CeciliaModuleEditor::editSoundObject()] ERROR: not an instance of AudioFile");
            this.ceciliaModule = null;
            return;
        }
        this.ceciliaModule = (CeciliaModule)sObj;
        this.editor.editCeciliaModule(this.ceciliaModule);
        this.properties.editCeciliaModule(this.ceciliaModule);
        this.fip.editCeciliaModule(this.ceciliaModule);
        this.grapher.editCeciliaModule(this.ceciliaModule);
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        CeciliaModuleEditor ceciliaModuleEditor = new CeciliaModuleEditor();
        ceciliaModuleEditor.editScoreObject((ScoreObject)new CeciliaModule());
        GUI.showComponentAsStandalone((Component)((Object)ceciliaModuleEditor), (String)"CeciliaModule Editor", (boolean)true);
    }
}

