/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import blue.BlueSystem;
import blue.soundObject.editor.ceciliaModule.Grapher;
import blue.utility.GUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.openide.util.ImageUtilities;

public class GrapherMenuBar
extends JToolBar {
    private static String IMAGE_HOME = "blue/soundObject/editor/ceciliaModule/images/";
    Grapher grapher;

    public GrapherMenuBar() {
        this.setFloatable(false);
        JButton cut = this.getButton("cut.gif");
        cut.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.cut"));
        cut.addActionListener(new CutAction());
        JButton copy = this.getButton("copy.gif");
        copy.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.copy"));
        copy.addActionListener(new CopyAction());
        JButton paste = this.getButton("paste.gif");
        paste.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.paste"));
        paste.addActionListener(new PasteAction());
        JButton reset = this.getButton("reset.gif");
        reset.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.reset"));
        reset.addActionListener(new ResetGraphAction());
        JButton exp = this.getButton("exp.gif");
        exp.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.export"));
        exp.addActionListener(new ExportAction());
        JButton imp = this.getButton("imp.gif");
        imp.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.import"));
        imp.addActionListener(new ImportAction());
        JButton moveUp = this.getButton("up1.gif");
        moveUp.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.moveUpOnePixel"));
        moveUp.addActionListener(new UpOneAction());
        JButton moveDown = this.getButton("down1.gif");
        moveUp.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.moveDownOnePixel"));
        moveDown.addActionListener(new DownOneAction());
        JButton sine = this.getButton("sines.gif");
        sine.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.generateSine"));
        sine.addActionListener(new GenerateSineAction());
        JButton square = this.getButton("square.gif");
        square.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.generateSquare"));
        square.addActionListener(new GenerateSquareAction());
        JButton drunk = this.getButton("drunks.gif");
        drunk.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.generateDrunk"));
        drunk.addActionListener(new DrunkGraphAction());
        JButton random = this.getButton("rand.gif");
        random.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.generateRandom"));
        random.addActionListener(new RandomGraphAction());
        JButton scatter = this.getButton("scatt.gif");
        scatter.setToolTipText(BlueSystem.getString((String)"ceciliaModule.graph.scatter"));
        scatter.addActionListener(new ScatterGraphAction());
        this.add(cut);
        this.add(copy);
        this.add(paste);
        this.add(reset);
        this.add(exp);
        this.add(imp);
        this.addSeparator();
        this.add(moveUp);
        this.add(moveDown);
        this.addSeparator();
        this.add(sine);
        this.add(square);
        this.add(drunk);
        this.add(random);
        this.add(scatter);
    }

    public void setGrapher(Grapher grapher) {
        this.grapher = grapher;
    }

    private JButton getButton(String imageName) {
        ImageIcon icon = new ImageIcon(ImageUtilities.loadImage((String)(IMAGE_HOME + imageName)));
        JButton button = new JButton(icon);
        button.setFocusPainted(false);
        return button;
    }

    public static void main(String[] args) {
        GUI.showComponentAsStandalone((Component)new GrapherMenuBar(), (String)"Grapher Bar Test", (boolean)true);
    }

    private final class DownOneAction
    implements ActionListener {
        private DownOneAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GrapherMenuBar.this.grapher != null) {
                GrapherMenuBar.this.grapher.moveDownGraph();
            }
        }
    }

    private final class UpOneAction
    implements ActionListener {
        private UpOneAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GrapherMenuBar.this.grapher != null) {
                GrapherMenuBar.this.grapher.moveUpGraph();
            }
        }
    }

    private final class ImportAction
    implements ActionListener {
        private ImportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private final class ExportAction
    implements ActionListener {
        private ExportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private final class PasteAction
    implements ActionListener {
        private PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GrapherMenuBar.this.grapher != null) {
                GrapherMenuBar.this.grapher.pasteGraph();
            }
        }
    }

    private final class CopyAction
    implements ActionListener {
        private CopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GrapherMenuBar.this.grapher != null) {
                GrapherMenuBar.this.grapher.copyGraph();
            }
        }
    }

    private final class CutAction
    implements ActionListener {
        private CutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GrapherMenuBar.this.grapher != null) {
                GrapherMenuBar.this.grapher.copyGraph();
                GrapherMenuBar.this.grapher.resetGraph();
            }
        }
    }

    private final class ResetGraphAction
    implements ActionListener {
        private ResetGraphAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GrapherMenuBar.this.grapher != null) {
                GrapherMenuBar.this.grapher.resetGraph();
            }
        }
    }

    private final class GenerateSineAction
    implements ActionListener {
        private GenerateSineAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GrapherMenuBar.this.grapher != null) {
                GrapherMenuBar.this.grapher.generateSineGraph();
            }
        }
    }

    private static final class GenerateSquareAction
    implements ActionListener {
        private GenerateSquareAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static final class DrunkGraphAction
    implements ActionListener {
        private DrunkGraphAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private final class RandomGraphAction
    implements ActionListener {
        private RandomGraphAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GrapherMenuBar.this.grapher != null) {
                GrapherMenuBar.this.grapher.generateRandomGraph();
            }
        }
    }

    private final class ScatterGraphAction
    implements ActionListener {
        private ScatterGraphAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

