/*
 * Decompiled with CFR 0.152.
 */
package blue.midi;

import blue.midi.MidiKeyMapping;
import blue.midi.MidiVelocityMapping;
import blue.soundObject.pianoRoll.Scale;
import blue.utility.NumberUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.text.MessageFormat;

public class MidiInputProcessor {
    private static final MessageFormat PCH_FORMAT = new MessageFormat("{0}.{1}");
    private static final MessageFormat NOTE_FORMAT = new MessageFormat("i{0}.{1} 0 -1 {2} {3}");
    private static final MessageFormat NOTE_OFF_FORMAT = new MessageFormat("i-{0}.{1} 0 0");
    private MidiKeyMapping keyMapping = MidiKeyMapping.PCH;
    private MidiVelocityMapping velMapping = MidiVelocityMapping.MIDI;
    private Scale scale = Scale.get12TET();
    private String pitchConstant = "";
    private String ampConstant = "";
    private double ampMin = 0.0;
    private double ampMax = 1.0;

    public MidiInputProcessor() {
    }

    public MidiInputProcessor(MidiInputProcessor mip) {
        this.keyMapping = mip.keyMapping;
        this.velMapping = mip.velMapping;
        this.scale = new Scale(mip.scale);
        this.pitchConstant = mip.pitchConstant;
        this.ampConstant = mip.ampConstant;
        this.ampMin = mip.ampMin;
        this.ampMax = mip.ampMax;
    }

    public String getAmpConstant() {
        return this.ampConstant;
    }

    public void setAmpConstant(String ampConstant) {
        this.ampConstant = ampConstant;
    }

    public double getAmpMax() {
        return this.ampMax;
    }

    public void setAmpMax(double ampMax) {
        this.ampMax = ampMax;
    }

    public double getAmpMin() {
        return this.ampMin;
    }

    public void setAmpMin(double ampMin) {
        this.ampMin = ampMin;
    }

    public String getPitchConstant() {
        return this.pitchConstant;
    }

    public void setPitchConstant(String pitchConstant) {
        this.pitchConstant = pitchConstant;
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    private String getPaddedNoteNum(int noteNum) {
        String noteStr = Integer.toString(noteNum);
        StringBuilder bdr = new StringBuilder();
        if (noteStr.length() < 3) {
            bdr.append("0");
        }
        if (noteStr.length() < 2) {
            bdr.append("1");
        }
        bdr.append(noteStr);
        return bdr.toString();
    }

    public String getNoteOn(String id, int noteNum, int key, int velocity) {
        return NOTE_FORMAT.format(new Object[]{id, this.getPaddedNoteNum(noteNum), this.processKey(key), this.processVelocity(velocity)});
    }

    public String getNoteOff(String id, int noteNum) {
        return NOTE_OFF_FORMAT.format(new Object[]{id, this.getPaddedNoteNum(noteNum)});
    }

    protected String processKey(int key) {
        String retVal = null;
        switch (this.keyMapping) {
            case MIDI: {
                retVal = Integer.toString(key);
                break;
            }
            case PCH: {
                retVal = this.convertPch(key);
                break;
            }
            case OCT: {
                retVal = this.convertOct(key);
                break;
            }
            case CONSTANT: {
                retVal = this.pitchConstant;
            }
            case TUNING_CPS: {
                int temp = key - 60;
                int octave = 8 + temp / this.scale.getNumScaleDegrees();
                int scaleDegree = temp % this.scale.getNumScaleDegrees();
                if (scaleDegree < 0) {
                    --octave;
                    scaleDegree = this.scale.getNumScaleDegrees() + scaleDegree;
                }
                retVal = NumberUtilities.formatDouble(this.scale.getFrequency(octave, scaleDegree));
                break;
            }
            case TUNING_BLUE_PCH: {
                int temp = key - 60;
                int octave = 8 + temp / this.scale.getNumScaleDegrees();
                int scaleDegree = temp % this.scale.getNumScaleDegrees();
                if (scaleDegree < 0) {
                    --octave;
                    scaleDegree = this.scale.getNumScaleDegrees() + scaleDegree;
                }
                retVal = octave + "." + scaleDegree;
            }
        }
        return retVal;
    }

    protected String convertPch(int midiKey) {
        int oct = midiKey / 12 + 3;
        int key = midiKey % 12;
        return PCH_FORMAT.format(new Object[]{oct, key < 10 ? "0" + key : Integer.valueOf(key)});
    }

    protected String convertOct(int midiKey) {
        return NumberUtilities.formatDouble((double)midiKey / 12.0 + 3.0);
    }

    protected String processVelocity(int key) {
        String retVal = null;
        switch (this.velMapping) {
            case MIDI: {
                retVal = Integer.toString(key);
                break;
            }
            case CONSTANT: {
                retVal = this.ampConstant;
                break;
            }
            case AMP: {
                retVal = Double.toString((double)(key * key) / 16239.0 * 30000.0);
            }
        }
        return retVal;
    }

    public MidiKeyMapping getKeyMapping() {
        return this.keyMapping;
    }

    public void setKeyMapping(MidiKeyMapping keyMapping) {
        this.keyMapping = keyMapping;
    }

    public MidiVelocityMapping getVelMapping() {
        return this.velMapping;
    }

    public void setVelMapping(MidiVelocityMapping velMapping) {
        this.velMapping = velMapping;
    }

    public static MidiInputProcessor loadFromXML(Element data) {
        MidiInputProcessor processor = new MidiInputProcessor();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "keyMapping": {
                    try {
                        processor.keyMapping = MidiKeyMapping.valueOf(node.getTextString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                case "velMapping": {
                    try {
                        processor.velMapping = MidiVelocityMapping.valueOf(node.getTextString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                case "pitchConstant": {
                    processor.pitchConstant = node.getTextString();
                    break;
                }
                case "ampConstant": {
                    processor.ampConstant = node.getTextString();
                    break;
                }
                case "scale": {
                    processor.scale = Scale.loadFromXML(node);
                }
            }
        }
        return processor;
    }

    public Element saveAsXML() {
        Element retVal = new Element("midiInputProcessor");
        retVal.addElement("keyMapping").setText(this.keyMapping.name());
        retVal.addElement("velMapping").setText(this.velMapping.name());
        retVal.addElement("pitchConstant").setText(this.pitchConstant);
        retVal.addElement("ampConstant").setText(this.ampConstant);
        retVal.addElement(this.scale.saveAsXML());
        return retVal;
    }
}

