/*
 * Decompiled with CFR 0.152.
 */
package blue.mixer;

import blue.CompileData;
import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.mixer.EffectManager;
import blue.mixer.MixerNode;
import blue.mixer.Send;
import blue.orchestra.GenericInstrument;
import blue.udo.OpcodeList;
import blue.util.ObservableArrayList;
import blue.util.ObservableList;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.text.StrBuilder;

public class Mixer {
    private static final MessageFormat GA_VAR = new MessageFormat("ga_bluemix_{0}_{1}");
    private static final MessageFormat SUBMIX_VAR = new MessageFormat("ga_bluesub_{0}_{1}");
    public static final String MASTER_CHANNEL = "Master";
    private ObservableList<ChannelList> channelListGroups = new ObservableArrayList<ChannelList>();
    private ChannelList channels = new ChannelList();
    private ChannelList subChannels = new ChannelList();
    private Channel master = new Channel();
    private boolean enabled = false;
    private double extraRenderTime = 0.0;
    private transient Map<String, String> subChannelDependencies = null;

    public Mixer() {
        this.channels = new ChannelList();
        this.subChannels = new ChannelList();
        this.master = new Channel();
        this.master.setName(MASTER_CHANNEL);
        this.channels.setListName("Orchestra");
        this.subChannels.setListName("SubChannels");
    }

    public Mixer(Mixer mixer) {
        this.channels = new ChannelList(mixer.channels);
        this.subChannels = new ChannelList(mixer.subChannels);
        this.master = new Channel(mixer.master);
        for (ChannelList chanList : mixer.channelListGroups) {
            this.channelListGroups.add(new ChannelList(chanList));
        }
        this.enabled = mixer.enabled;
        this.extraRenderTime = mixer.extraRenderTime;
    }

    public static Mixer loadFromXML(Element data) throws Exception {
        Mixer mixer = new Mixer();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            block7 : switch (nodeName = node.getName()) {
                case "enabled": {
                    mixer.setEnabled(XMLUtilities.readBoolean(node));
                    break;
                }
                case "extraRenderTime": {
                    mixer.setExtraRenderTime(XMLUtilities.readDouble(node));
                    break;
                }
                case "channelList": {
                    String listType;
                    switch (listType = node.getAttributeValue("list")) {
                        case "channels": {
                            mixer.setChannels(ChannelList.loadFromXML(node));
                            mixer.getChannels().setListName("Orchestra");
                            mixer.getChannels().setListNameEditSupported(false);
                            break block7;
                        }
                        case "subChannels": {
                            mixer.setSubChannels(ChannelList.loadFromXML(node));
                            mixer.getSubChannels().setListName("SubChannels");
                            mixer.getSubChannels().setListNameEditSupported(false);
                        }
                    }
                    break;
                }
                case "channelListGroups": {
                    Elements listGroupsNodes = node.getElements();
                    while (listGroupsNodes.hasMoreElements()) {
                        mixer.channelListGroups.add(ChannelList.loadFromXML(listGroupsNodes.next()));
                    }
                    break;
                }
                case "channel": {
                    mixer.setMaster(Channel.loadFromXML(node));
                }
            }
        }
        return mixer;
    }

    public Element saveAsXML() {
        Element retVal = new Element("mixer");
        retVal.addElement(XMLUtilities.writeBoolean("enabled", this.isEnabled()));
        retVal.addElement(XMLUtilities.writeDouble("extraRenderTime", this.extraRenderTime));
        if (this.channelListGroups.size() > 0) {
            Element groupsNode = new Element("channelListGroups");
            retVal.addElement(groupsNode);
            for (ChannelList list : this.channelListGroups) {
                groupsNode.addElement(list.saveAsXML());
            }
        }
        Element channelsNode = this.channels.saveAsXML();
        channelsNode.setAttribute("list", "channels");
        retVal.addElement(channelsNode);
        Element subChannelsNode = this.subChannels.saveAsXML();
        subChannelsNode.setAttribute("list", "subChannels");
        retVal.addElement(subChannelsNode);
        retVal.addElement(this.master.saveAsXML());
        return retVal;
    }

    public ObservableList<ChannelList> getChannelListGroups() {
        return this.channelListGroups;
    }

    public Channel getChannel(int index) {
        return (Channel)this.channels.get(index);
    }

    public List<Channel> getAllSourceChannels() {
        ArrayList<Channel> allChannels = new ArrayList<Channel>();
        for (ChannelList list : this.channelListGroups) {
            allChannels.addAll(list);
        }
        allChannels.addAll(this.channels);
        return allChannels;
    }

    public Channel findChannelById(String id) {
        if (id == null) {
            return null;
        }
        for (ChannelList list : this.channelListGroups) {
            for (Channel c : list) {
                if (!id.equals(c.getAssociation())) continue;
                return c;
            }
        }
        return null;
    }

    public ChannelList getChannels() {
        return this.channels;
    }

    public Channel getSubChannel(int index) {
        return (Channel)this.subChannels.get(index);
    }

    public ChannelList getSubChannels() {
        return this.subChannels;
    }

    public Channel getMaster() {
        return this.master;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static String getChannelVar(int blueChannelId, int channel) {
        return GA_VAR.format(new Object[]{new Integer(blueChannelId), new Integer(channel)});
    }

    public static String getSubChannelVar(String subChannelName, int channel) {
        return SUBMIX_VAR.format(new Object[]{subChannelName, new Integer(channel)});
    }

    public String getVar(CompileData data, Channel c, int channel) {
        String name = c.getName();
        String retVal = this.isChannel(c) ? Mixer.getChannelVar(data.getChannelIdAssignments().get(c), channel) : Mixer.getSubChannelVar(name, channel);
        return retVal.replaceAll(" ", "");
    }

    public String getInitStatements(CompileData data, int nchnls) {
        int j;
        StrBuilder buffer = new StrBuilder();
        List<Channel> allChannels = this.getAllSourceChannels();
        for (Channel c : allChannels) {
            for (j = 0; j < nchnls; ++j) {
                buffer.append(Mixer.getChannelVar(data.getChannelIdAssignments().get(c), j)).append("\tinit\t0\n");
            }
        }
        for (int i = 0; i < this.subChannels.size(); ++i) {
            Channel c;
            c = (Channel)this.subChannels.get(i);
            for (j = 0; j < nchnls; ++j) {
                buffer.append(Mixer.getSubChannelVar(c.getName(), j)).append("\tinit\t0\n");
            }
        }
        for (int j2 = 0; j2 < nchnls; ++j2) {
            buffer.append(Mixer.getSubChannelVar(MASTER_CHANNEL, j2)).append("\tinit\t0\n");
        }
        return buffer.toString();
    }

    public String getClearStatements(CompileData data, int nchnls) {
        int j;
        StrBuilder buffer = new StrBuilder();
        List<Channel> allChannels = this.getAllSourceChannels();
        for (Channel c : allChannels) {
            for (j = 0; j < nchnls; ++j) {
                buffer.append(Mixer.getChannelVar(data.getChannelIdAssignments().get(c), j)).append(" = 0\n");
            }
        }
        for (Channel c : this.subChannels) {
            for (j = 0; j < nchnls; ++j) {
                buffer.append(Mixer.getSubChannelVar(c.getName(), j)).append(" = 0\n");
            }
        }
        for (int j2 = 0; j2 < nchnls; ++j2) {
            buffer.append(Mixer.getSubChannelVar(MASTER_CHANNEL, j2)).append(" = 0\n");
        }
        return buffer.toString();
    }

    public GenericInstrument getMixerInstrument(CompileData data, OpcodeList udos, int nchnls) {
        GenericInstrument instr = new GenericInstrument();
        instr.setName("Blue Mixer Instrument");
        StrBuilder buffer = new StrBuilder();
        MixerNode node = MixerNode.getMixerGraph(this);
        EffectManager manager = new EffectManager();
        buffer.append(MixerNode.getMixerCode(data, this, udos, manager, node, nchnls));
        buffer.append("outc ");
        for (int i = 0; i < nchnls; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getVar(data, this.master, i));
        }
        buffer.append("\n").append(this.getClearStatements(data, nchnls));
        instr.setText(buffer.toString());
        return instr;
    }

    public Send[] getAllSends() {
        Send[] temp;
        Send[] sends;
        Send[] allSends = new Send[]{};
        for (int i = 0; i < this.getSubChannels().size(); ++i) {
            Channel c = (Channel)this.getSubChannels().get(i);
            sends = c.getSends();
            if (sends.length == 0) continue;
            temp = new Send[allSends.length + sends.length];
            System.arraycopy(allSends, 0, temp, 0, allSends.length);
            System.arraycopy(sends, 0, temp, allSends.length, sends.length);
            allSends = temp;
        }
        for (Channel c : this.getAllSourceChannels()) {
            sends = c.getSends();
            if (sends.length == 0) continue;
            temp = new Send[allSends.length + sends.length];
            System.arraycopy(allSends, 0, temp, 0, allSends.length);
            System.arraycopy(sends, 0, temp, allSends.length, sends.length);
            allSends = temp;
        }
        return allSends;
    }

    public boolean isSubChannel(Channel channel) {
        return this.subChannels.contains(channel);
    }

    public boolean isChannel(Channel channel) {
        return this.getAllSourceChannels().contains(channel);
    }

    public void setChannels(ChannelList channels) {
        this.channels = channels;
    }

    public void setMaster(Channel master) {
        this.master = master;
    }

    public void setSubChannels(ChannelList subChannels) {
        this.subChannels = subChannels;
    }

    public double getExtraRenderTime() {
        return this.extraRenderTime;
    }

    public void setExtraRenderTime(double extraRenderTime) {
        this.extraRenderTime = extraRenderTime;
    }

    public void addSubChannelDependency(String subChannelName) {
        if (this.subChannelDependencies == null) {
            this.subChannelDependencies = new HashMap<String, String>();
        }
        this.subChannelDependencies.put(subChannelName, subChannelName);
    }

    public boolean hasSubChannelDependency(String subChannelName) {
        if (this.subChannelDependencies == null) {
            return false;
        }
        return this.subChannelDependencies.containsKey(subChannelName);
    }

    public boolean hasSubChannelDependencies() {
        if (this.subChannelDependencies == null) {
            return false;
        }
        return this.subChannelDependencies.size() > 0;
    }

    public boolean sendsTo(Channel subChannel1, Channel subChannel2) {
        Send[] sends = subChannel1.getSends();
        String target = subChannel2.getName();
        for (int i = 0; i < sends.length; ++i) {
            String channelName = sends[i].getSendChannel();
            if (channelName.equals(MASTER_CHANNEL)) continue;
            if (channelName.equals(target)) {
                return true;
            }
            if (!this.sendsTo(this.getSubChannelByName(channelName), subChannel2)) continue;
            return true;
        }
        return false;
    }

    private Channel getSubChannelByName(String name) {
        for (int i = 0; i < this.subChannels.size(); ++i) {
            Channel c = (Channel)this.subChannels.get(i);
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public Map<String, Channel> getSubChannelCache() {
        HashMap<String, Channel> subChannelCache = new HashMap<String, Channel>();
        for (int i = 0; i < this.getSubChannels().size(); ++i) {
            Channel subChannel = this.getSubChannel(i);
            subChannelCache.put(subChannel.getName(), subChannel);
        }
        return subChannelCache;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }
}

