/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import electric.xml.Element;

public class MultiplyProcessor
implements NoteProcessor {
    double value = 1.0;
    int pfield = 4;

    public MultiplyProcessor() {
    }

    public MultiplyProcessor(MultiplyProcessor mp) {
        this.value = mp.value;
        this.pfield = mp.pfield;
    }

    public String toString() {
        return "[multiply]";
    }

    public String getPfield() {
        return Integer.toString(this.pfield);
    }

    public void setPfield(String pfield) {
        this.pfield = Integer.parseInt(pfield);
    }

    public String getVal() {
        return Double.toString(this.value);
    }

    public void setVal(String value) {
        this.value = Double.parseDouble(value);
    }

    @Override
    public final void processNotes(NoteList in) throws NoteProcessorException {
        double fieldVal = 0.0;
        for (int i = 0; i < in.size(); ++i) {
            Note temp = (Note)in.get(i);
            try {
                fieldVal = Double.parseDouble(temp.getPField(this.pfield));
            }
            catch (NumberFormatException ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.pfieldNotDouble"), this.pfield);
            }
            catch (Exception ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield);
            }
            temp.setPField(Double.toString(fieldVal * this.value), this.pfield);
        }
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i * 2 + " 2 3 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        MultiplyProcessor mp = new MultiplyProcessor();
        mp.setPfield("2");
        mp.setVal("2.2f");
        try {
            mp.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public static NoteProcessor loadFromXML(Element data) {
        MultiplyProcessor mp = new MultiplyProcessor();
        mp.setPfield(data.getElement("pfield").getTextString());
        mp.setVal(data.getElement("value").getTextString());
        return mp;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield").setText(this.getPfield());
        retVal.addElement("value").setText(this.getVal());
        return retVal;
    }

    @Override
    public MultiplyProcessor deepCopy() {
        return new MultiplyProcessor(this);
    }
}

