/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;

public class RandomMultiplyProcessor
implements NoteProcessor {
    int pfield = 4;
    double min = 0.0;
    double max = 1.0;
    boolean seedUsed = false;
    long seed = 0L;

    public RandomMultiplyProcessor() {
    }

    public RandomMultiplyProcessor(RandomMultiplyProcessor rmp) {
        this.pfield = rmp.pfield;
        this.min = rmp.min;
        this.max = rmp.max;
        this.seedUsed = rmp.seedUsed;
        this.seed = rmp.seed;
    }

    public String toString() {
        return "[random multiply]";
    }

    public String getPfield() {
        return Integer.toString(this.pfield);
    }

    public void setPfield(String pfield) {
        this.pfield = Integer.parseInt(pfield);
    }

    public String getMin() {
        return Double.toString(this.min);
    }

    public void setMin(String value) {
        this.min = Double.parseDouble(value);
    }

    public String getMax() {
        return Double.toString(this.max);
    }

    public void setMax(String value) {
        this.max = Double.parseDouble(value);
    }

    public String getSeedUsed() {
        return Boolean.toString(this.seedUsed);
    }

    public void setSeedUsed(String seedUsed) {
        this.seedUsed = Boolean.valueOf(seedUsed.trim().toLowerCase());
    }

    public String getSeed() {
        return Long.toString(this.seed);
    }

    public void setSeed(String seed) {
        this.seed = Long.parseLong(seed);
    }

    @Override
    public final void processNotes(NoteList in) throws NoteProcessorException {
        double range = this.max - this.min;
        double fieldVal = 0.0;
        Random r = this.seedUsed ? new Random(this.seed) : new Random();
        for (int i = 0; i < in.size(); ++i) {
            Note temp = (Note)in.get(i);
            try {
                fieldVal = Double.parseDouble(temp.getPField(this.pfield));
            }
            catch (NumberFormatException ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.pfieldNotDouble"), this.pfield);
            }
            catch (Exception ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield);
            }
            double randVal = r.nextDouble() * range + this.min;
            temp.setPField(Double.toString(fieldVal * randVal), this.pfield);
        }
    }

    public static NoteProcessor loadFromXML(Element data) {
        RandomMultiplyProcessor mp = new RandomMultiplyProcessor();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            switch (node.getName()) {
                case "pfield": {
                    mp.setPfield(node.getTextString());
                    break;
                }
                case "min": {
                    mp.setMin(node.getTextString());
                    break;
                }
                case "max": {
                    mp.setMax(node.getTextString());
                    break;
                }
                case "seedUsed": {
                    mp.setSeedUsed(node.getTextString());
                    break;
                }
                case "seed": {
                    mp.setSeed(node.getTextString());
                }
            }
        }
        return mp;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield").setText(this.getPfield());
        retVal.addElement("min").setText(this.getMin());
        retVal.addElement("max").setText(this.getMax());
        retVal.addElement("seedUsed").setText(this.getSeedUsed());
        retVal.addElement("seed").setText(this.getSeed());
        return retVal;
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i * 2 + " 2 3 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        RandomMultiplyProcessor mp = new RandomMultiplyProcessor();
        mp.setPfield("3");
        mp.setMin("1f");
        mp.setMax("1.5f");
        try {
            mp.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    @Override
    public RandomMultiplyProcessor deepCopy() {
        return new RandomMultiplyProcessor(this);
    }
}

