/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.flowGraph;

import blue.orchestra.flowGraph.Cable;
import blue.orchestra.flowGraph.GraphUnit;
import blue.orchestra.flowGraph.GraphUnitComparator;
import blue.orchestra.flowGraph.Port;
import blue.orchestra.flowGraph.PortList;
import blue.orchestra.flowGraph.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class FlowGraph {
    private ArrayList units = new ArrayList();
    private ArrayList cables = new ArrayList();
    private String name;

    public String generateInstrument() {
        StringBuilder buffer = new StringBuilder();
        Collections.sort(this.units, new GraphUnitComparator());
        VariableManager varManager = new VariableManager();
        varManager.setupOutPorts(this.units);
        for (GraphUnit graphUnit : this.units) {
            if (graphUnit.getInputs().size() == 0 && graphUnit.getOutputs().size() == 0) continue;
            buffer.append(this.processGraphUnit(graphUnit, varManager)).append("\n");
        }
        return buffer.toString();
    }

    private String processGraphUnit(GraphUnit graphUnit, VariableManager varManager) {
        Unit unit = graphUnit.unit;
        String code = varManager.getCodeWithReplacedOutputs(graphUnit);
        PortList inputs = graphUnit.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Port port = inputs.getPort(i);
            Cable[] connections = this.getInConnections(graphUnit, i);
            if (connections.length == 0) {
                code = code.replaceAll("\\$" + port.name, port.defaultValue);
                continue;
            }
            if (port.allowsMultiple) continue;
            Cable c = connections[0];
            String newVarName = varManager.getVariableForPort(c.getsendUnit(), c.sendPortIndex);
            code = code.replaceAll("\\$" + port.name, newVarName);
        }
        return code;
    }

    private Cable[] getInConnections(GraphUnit graphUnit, int portNum) {
        ArrayList<Cable> temp = new ArrayList<Cable>();
        for (int i = 0; i < this.cables.size(); ++i) {
            Cable cable = (Cable)this.cables.get(i);
            if (cable.getToUnit() != graphUnit || cable.receivePortIndex != portNum) continue;
            temp.add(cable);
        }
        Cable[] conn = new Cable[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            conn[i] = (Cable)temp.get(i);
        }
        return conn;
    }

    public void addGraphUnit(GraphUnit newUnit) {
        this.units.add(newUnit);
    }

    public void removeUnit(int n) {
        this.units.remove(n);
    }

    public void removeUnit(GraphUnit u) {
        this.units.remove(u);
    }

    public void addCable(Cable newCable) {
        this.cables.add(newCable);
    }

    public void removeCable(int n) {
        this.cables.remove(n);
    }

    public String createCsoundCode() {
        return null;
    }

    public int getNumUnits() {
        return this.units.size();
    }

    public int getNumCables() {
        return this.cables.size();
    }

    public GraphUnit getGraphUnit(int i) {
        return (GraphUnit)this.units.get(i);
    }

    public Cable getCable(int i) {
        return (Cable)this.cables.get(i);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
    }

    private static class PortMapping {
        GraphUnit graphUnit = null;
        String[] portVarNames = null;

        private PortMapping() {
        }
    }

    private class VariableManager {
        private final String[] VAR_PREFIXES = new String[]{"i", "k", "a", "S", "f", "w"};
        int[] portCounters;
        private HashMap portMappings = new HashMap();

        public VariableManager() {
            this.portCounters = new int[this.VAR_PREFIXES.length];
            for (int i = 0; i < this.portCounters.length; ++i) {
                this.portCounters[i] = 0;
            }
        }

        public String getCodeWithReplacedOutputs(GraphUnit graphUnit) {
            if (!this.portMappings.containsKey(graphUnit)) {
                return null;
            }
            PortMapping mapping = (PortMapping)this.portMappings.get(graphUnit);
            Unit unit = graphUnit.unit;
            PortList outs = unit.getOutputs();
            String code = unit.getCode();
            for (int i = 0; i < mapping.portVarNames.length; ++i) {
                Port p = outs.getPort(i);
                code = code.replaceAll("\\$" + p.name, mapping.portVarNames[i]);
            }
            return code;
        }

        public void setupOutPorts(ArrayList units) {
            for (GraphUnit graphUnit : units) {
                PortList outs = graphUnit.getOutputs();
                PortMapping mapping = new PortMapping();
                mapping.graphUnit = graphUnit;
                mapping.portVarNames = new String[outs.size()];
                for (int i = 0; i < outs.size(); ++i) {
                    Port p = outs.getPort(i);
                    mapping.portVarNames[i] = this.getVariable(p.rate);
                }
                this.portMappings.put(graphUnit, mapping);
            }
        }

        private String getVariable(int portType) {
            int n = portType;
            int n2 = this.portCounters[n];
            this.portCounters[n] = n2 + 1;
            int counter = n2;
            return this.VAR_PREFIXES[portType] + counter;
        }

        public String getVariableForPort(GraphUnit unit, int portNum) {
            if (!this.portMappings.containsKey(unit)) {
                return null;
            }
            PortMapping mapping = (PortMapping)this.portMappings.get(unit);
            return mapping.portVarNames[portNum];
        }
    }
}

