/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.automation.LineColors;
import blue.components.lines.Line;
import blue.soundObject.AbstractLineObject;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Map;

public class LineObject
extends AbstractLineObject {
    public LineObject() {
        this.setName("LineObject");
    }

    public LineObject(LineObject lObj) {
        super(lObj);
    }

    @Override
    protected String generateLineInstrument(Line line) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("kphase line p4, p3, p5\n");
        buffer.append("gk").append(line.getVarName());
        buffer.append("\ttablei kphase, p6, 1");
        return buffer.toString();
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        LineObject lObj = new LineObject();
        SoundObjectUtilities.initBasicFromXML(data, lObj);
        Elements lines = data.getElements();
        int counter = 0;
        while (lines.hasMoreElements()) {
            Element node = lines.next();
            if (!node.getName().equals("line")) continue;
            Line l = Line.loadFromXML(node);
            lObj.getLines().add(l);
            if (l.getColor() == null) {
                l.setColor(LineColors.getColor(counter));
            }
            ++counter;
        }
        return lObj;
    }

    @Override
    public LineObject deepCopy() {
        return new LineObject(this);
    }
}

