/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.jmask.Table;
import blue.soundObject.jmask.Utilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Accumulator {
    public static final int ON = 0;
    public static final int LIMIT = 1;
    public static final int MIRROR = 2;
    public static final int WRAP = 3;
    public static final String[] MODES = new String[]{"On", "Limit", "Mirror", "Wrap"};
    Table highTable;
    Table lowTable;
    private boolean highTableEnabled = false;
    private boolean lowTableEnabled = false;
    int mode = 0;
    double low = 0.0;
    double high = 1.0;
    double initialValue = 0.0;
    boolean enabled = false;
    double runningValue = 0.0;
    boolean firstTime = true;
    private transient double duration = 1.0;

    public Accumulator() {
        this.highTable = new Table();
        this.lowTable = new Table();
    }

    public Accumulator(Accumulator acc) {
        this.highTable = new Table(acc.highTable);
        this.lowTable = new Table(acc.lowTable);
        this.highTableEnabled = acc.highTableEnabled;
        this.lowTableEnabled = acc.lowTableEnabled;
        this.mode = acc.mode;
        this.low = acc.low;
        this.high = acc.high;
        this.initialValue = acc.initialValue;
        this.enabled = acc.enabled;
    }

    public static Accumulator loadFromXML(Element data) {
        Accumulator retVal = new Accumulator();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "table": {
                    Table t = Table.loadFromXML(node);
                    String tabInstance = node.getAttributeValue("tableId");
                    if (tabInstance == null) break;
                    if (tabInstance.equals("highTable")) {
                        retVal.highTable = t;
                        break;
                    }
                    if (!tabInstance.equals("lowTable")) break;
                    retVal.lowTable = t;
                    break;
                }
                case "highTableEnabled": {
                    retVal.highTableEnabled = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "lowTableEnabled": {
                    retVal.lowTableEnabled = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "mode": {
                    retVal.mode = Integer.parseInt(node.getTextString());
                    break;
                }
                case "low": {
                    retVal.low = Double.parseDouble(node.getTextString());
                    break;
                }
                case "high": {
                    retVal.high = Double.parseDouble(node.getTextString());
                    break;
                }
                case "initialValue": {
                    retVal.initialValue = Double.parseDouble(node.getTextString());
                    break;
                }
                case "enabled": {
                    retVal.enabled = Boolean.valueOf(node.getTextString());
                }
            }
        }
        return retVal;
    }

    public Element saveAsXML() {
        Element retVal = new Element("accumulator");
        Element hTableNode = this.highTable.saveAsXML();
        hTableNode.setAttribute("tableId", "highTable");
        retVal.addElement(hTableNode);
        Element lTableNode = this.lowTable.saveAsXML();
        lTableNode.setAttribute("tableId", "lowTable");
        retVal.addElement(lTableNode);
        retVal.addElement(XMLUtilities.writeBoolean("highTableEnabled", this.highTableEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("lowTableEnabled", this.lowTableEnabled));
        retVal.addElement(XMLUtilities.writeInt("mode", this.mode));
        retVal.addElement(XMLUtilities.writeDouble("low", this.low));
        retVal.addElement(XMLUtilities.writeDouble("high", this.high));
        retVal.addElement(XMLUtilities.writeDouble("initialValue", this.initialValue));
        retVal.addElement(XMLUtilities.writeBoolean("enabled", this.enabled));
        return retVal;
    }

    public double getValue(double time, double val) {
        if (!this.enabled) {
            return val;
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.runningValue = this.initialValue;
        }
        this.runningValue += val;
        double lowerBound = this.lowTableEnabled ? this.lowTable.getValue(time / this.duration) : this.low;
        double upperBound = this.highTableEnabled ? this.highTable.getValue(time / this.duration) : this.high;
        switch (this.mode) {
            case 0: {
                break;
            }
            case 1: {
                this.runningValue = Utilities.limit(this.runningValue, lowerBound, upperBound);
                break;
            }
            case 2: {
                this.runningValue = Utilities.mirror(this.runningValue, lowerBound, upperBound);
                break;
            }
            case 3: {
                this.runningValue = Utilities.wrap(this.runningValue, lowerBound, upperBound);
            }
        }
        return this.runningValue;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public double getHigh() {
        return this.high;
    }

    public void setHigh(double high) {
        this.high = high;
    }

    public Table getHighTable() {
        return this.highTable;
    }

    public void setHighTable(Table highTable) {
        this.highTable = highTable;
    }

    public double getLow() {
        return this.low;
    }

    public void setLow(double low) {
        this.low = low;
    }

    public Table getLowTable() {
        return this.lowTable;
    }

    public void setLowTable(Table lowTable) {
        this.lowTable = lowTable;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public double getRunningValue() {
        return this.runningValue;
    }

    public void setRunningValue(double value) {
        this.runningValue = value;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isHighTableEnabled() {
        return this.highTableEnabled;
    }

    public void setHighTableEnabled(boolean highTableEnabled) {
        this.highTableEnabled = highTableEnabled;
    }

    public boolean isLowTableEnabled() {
        return this.lowTableEnabled;
    }

    public void setLowTableEnabled(boolean lowTableEnabled) {
        this.lowTableEnabled = lowTableEnabled;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }
}

