/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.jmask.Accumulatable;
import blue.soundObject.jmask.Generator;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Constant
implements Generator,
Accumulatable {
    double value = 1.0;

    public Constant() {
    }

    public Constant(Constant constant) {
        this.value = constant.value;
    }

    public static Generator loadFromXML(Element data) {
        Constant constant = new Constant();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            if (!nodeName.equals("value")) continue;
            constant.setValue(Double.parseDouble(node.getTextString()));
        }
        return constant;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("generator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("value").setText(Double.toString(this.value));
        return retVal;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void initialize(double duration) {
    }

    @Override
    public double getValue(double time, Random rnd) {
        return this.value;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public Constant deepCopy() {
        return new Constant(this);
    }
}

