/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask.probability;

import blue.soundObject.jmask.Table;
import blue.soundObject.jmask.probability.ProbabilityGenerator;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;

public class Exponential
implements ProbabilityGenerator {
    public static final int DECREASING = 0;
    public static final int INCREASING = 1;
    public static final int BILATERAL = 2;
    private int direction = 0;
    private double lambda = 0.5;
    private Table lambdaTable;
    private boolean lambdaTableEnabled = false;

    public Exponential() {
        this.lambdaTable = new Table();
        this.lambdaTable.setMin(1.0E-4, false);
    }

    public Exponential(Exponential expon) {
        this.direction = expon.direction;
        this.lambda = expon.lambda;
        this.lambdaTable = new Table(expon.lambdaTable);
        this.lambdaTableEnabled = expon.lambdaTableEnabled;
    }

    public static ProbabilityGenerator loadFromXML(Element data) {
        Exponential retVal = new Exponential();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "direction": {
                    retVal.direction = XMLUtilities.readInt(node);
                    break;
                }
                case "lambda": {
                    retVal.lambda = XMLUtilities.readDouble(node);
                    break;
                }
                case "lambdaTableEnabled": {
                    retVal.lambdaTableEnabled = XMLUtilities.readBoolean(node);
                    break;
                }
                case "table": {
                    retVal.lambdaTable = Table.loadFromXML(node);
                }
            }
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("probabilityGenerator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement(XMLUtilities.writeInt("direction", this.direction));
        retVal.addElement(XMLUtilities.writeDouble("lambda", this.lambda));
        retVal.addElement(XMLUtilities.writeBoolean("lambdaTableEnabled", this.lambdaTableEnabled));
        retVal.addElement(this.lambdaTable.saveAsXML());
        return retVal;
    }

    @Override
    public String getName() {
        return "Exponential";
    }

    @Override
    public double getValue(double time, Random rnd) {
        double x;
        double localLambda = this.lambdaTableEnabled ? this.lambdaTable.getValue(time) : this.lambda;
        if (this.direction == 2) {
            double e;
            do {
                if ((x = 2.0 * rnd.nextDouble()) > 1.0) {
                    x = 2.0 - x;
                    e = -Math.log(x);
                    continue;
                }
                e = Math.log(x);
            } while ((e = e / 14.0 / localLambda + 0.5) > 1.0 || e < 0.0);
            x = e;
        } else {
            while ((x = rnd.nextDouble()) == 0.0 || (x = -Math.log(x) / 7.0 / localLambda) > 1.0) {
            }
            if (this.direction == 1) {
                x = 1.0 - x;
            }
        }
        return x;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public Table getLambdaTable() {
        return this.lambdaTable;
    }

    public void setLambdaTable(Table lambdaTable) {
        this.lambdaTable = lambdaTable;
    }

    public boolean isLambdaTableEnabled() {
        return this.lambdaTableEnabled;
    }

    public void setLambdaTableEnabled(boolean lambdaTableEnabled) {
        this.lambdaTableEnabled = lambdaTableEnabled;
    }

    @Override
    public Exponential deepCopy() {
        return new Exponential(this);
    }
}

