/*
 * Decompiled with CFR 0.152.
 */
package blue.projects;

import blue.BlueData;
import blue.BlueSystem;
import blue.ProjectProperties;
import blue.project.ProjectPlugin;
import blue.projects.BlueProject;
import blue.projects.recentProjects.RecentProjectsList;
import blue.score.Score;
import blue.score.layers.LayerGroup;
import blue.settings.DiskRenderSettings;
import blue.settings.GeneralSettings;
import blue.settings.ProjectDefaultsSettings;
import blue.settings.RealtimeRenderSettings;
import blue.soundObject.PolyObject;
import blue.ui.utilities.FileChooserManager;
import blue.undo.BlueUndoManager;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javafx.stage.FileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public class BlueProjectManager {
    public static final String CURRENT_PROJECT = "currentProject";
    public static final String PROJECT_FILE = "projectFile";
    private static BlueProjectManager instance = null;
    ArrayList<BlueProject> projects = new ArrayList();
    BlueProject currentProject = null;
    public Vector<PropertyChangeListener> listeners = null;

    public boolean isProjectStillOpen(BlueProject project) {
        return this.projects.contains(project);
    }

    public static BlueProjectManager getInstance() {
        if (instance == null) {
            instance = new BlueProjectManager();
        }
        return instance;
    }

    private BlueProjectManager() {
        BlueProject project = BlueProjectManager.createNewProject();
        this.setCurrentProject(project);
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.setMultiSelectionEnabled(this.getClass(), false);
        fcm.addFilter(this.getClass(), new FileChooser.ExtensionFilter("blue Project File", new String[]{"*.blue"}));
        fcm.setSelectedFile(this.getClass(), new File(GeneralSettings.getInstance().getDefaultDirectory() + File.separator + "default.blue"));
    }

    public static BlueProject createNewProject() {
        BlueData blueData = new BlueData();
        BlueProject project = new BlueProject(blueData, null);
        for (LayerGroup layerGroup : blueData.getScore()) {
            if (!(layerGroup instanceof PolyObject)) continue;
            PolyObject pObj = (PolyObject)layerGroup;
            pObj.setDefaultHeightIndex(ProjectDefaultsSettings.getInstance().layerHeightDefault);
            if (pObj.size() != 0) continue;
            pObj.newLayerAt(-1);
        }
        blueData.getMixer().setEnabled(ProjectDefaultsSettings.getInstance().mixerEnabled);
        ProjectProperties proj = blueData.getProjectProperties();
        proj.author = ProjectDefaultsSettings.getInstance().defaultAuthor;
        RealtimeRenderSettings rtSettings = RealtimeRenderSettings.getInstance();
        proj.sampleRate = rtSettings.defaultSr;
        proj.ksmps = rtSettings.defaultKsmps;
        proj.channels = rtSettings.defaultNchnls;
        proj.useZeroDbFS = rtSettings.useZeroDbFS;
        proj.zeroDbFS = rtSettings.zeroDbFS;
        proj.useAudioOut = rtSettings.audioOutEnabled;
        proj.useAudioIn = rtSettings.audioInEnabled;
        proj.useMidiIn = rtSettings.midiInEnabled;
        proj.useMidiOut = rtSettings.midiOutEnabled;
        proj.noteAmpsEnabled = rtSettings.noteAmpsEnabled;
        proj.outOfRangeEnabled = rtSettings.outOfRangeEnabled;
        proj.warningsEnabled = rtSettings.warningsEnabled;
        proj.benchmarkEnabled = rtSettings.benchmarkEnabled;
        proj.advancedSettings = rtSettings.advancedSettings;
        DiskRenderSettings diskSettings = DiskRenderSettings.getInstance();
        proj.diskSampleRate = diskSettings.defaultSr;
        proj.diskKsmps = diskSettings.defaultKsmps;
        proj.diskChannels = diskSettings.defaultNchnls;
        proj.diskUseZeroDbFS = diskSettings.useZeroDbFS;
        proj.diskZeroDbFS = diskSettings.zeroDbFS;
        proj.diskNoteAmpsEnabled = diskSettings.noteAmpsEnabled;
        proj.diskOutOfRangeEnabled = diskSettings.outOfRangeEnabled;
        proj.diskWarningsEnabled = diskSettings.warningsEnabled;
        proj.diskBenchmarkEnabled = diskSettings.benchmarkEnabled;
        proj.diskAdvancedSettings = diskSettings.advancedSettings;
        return project;
    }

    public void setCurrentProject(BlueProject project) {
        BlueProject previousProject = this.currentProject;
        this.currentProject = project;
        if (!this.projects.contains(project)) {
            this.addProject(project);
        }
        if (this.currentProject != null) {
            BlueUndoManager.setUndoGroup(project.getUndoManager());
            File f = project.getDataFile();
            BlueSystem.setCurrentBlueData((BlueData)project.getData());
            if (f != null) {
                BlueSystem.setCurrentProjectDirectory((File)f.getParentFile());
            } else {
                BlueSystem.setCurrentProjectDirectory(null);
            }
            Score score = project.getData().getScore();
            Collection plugins = Lookups.forPath((String)"blue/project/plugins").lookupAll(ProjectPlugin.class);
            for (ProjectPlugin plugin : plugins) {
                plugin.preRender(project.getData());
            }
            new Thread(() -> {
                try {
                    score.processOnLoad();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }).start();
        }
        this.fireUpdatedCurrentProject(previousProject, this.currentProject);
    }

    public void addProject(BlueProject project) {
        this.projects.add(project);
    }

    public void closeCurrentProject() {
        if (this.projects.isEmpty()) {
            return;
        }
        if (this.saveCheck()) {
            if (this.currentProject.getTempFile() != null && !this.currentProject.isOpenedFromTempFile()) {
                this.currentProject.getTempFile().delete();
            }
            int index = this.projects.indexOf(this.currentProject);
            this.projects.remove(this.currentProject);
            if (this.projects.isEmpty()) {
                this.setCurrentProject(BlueProjectManager.createNewProject());
            } else if (index >= this.projects.size()) {
                this.setCurrentProject(this.projects.get(this.projects.size() - 1));
            } else {
                this.setCurrentProject(this.projects.get(index));
            }
        }
    }

    public BlueProject getCurrentProject() {
        return this.currentProject;
    }

    public BlueData getCurrentBlueData() {
        if (this.currentProject == null) {
            return null;
        }
        return this.currentProject.getData();
    }

    public int getNumProjects() {
        return this.projects.size();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(pcl);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners != null) {
            this.listeners.remove(pcl);
        }
    }

    protected synchronized void fireUpdatedCurrentProject(BlueProject oldProject, BlueProject newProject) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        PropertyChangeEvent pce = new PropertyChangeEvent(this, CURRENT_PROJECT, oldProject, newProject);
        for (PropertyChangeListener pcl : this.listeners) {
            pcl.propertyChange(pce);
        }
    }

    protected synchronized void fireProjectFileChanged() {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        PropertyChangeEvent pce = new PropertyChangeEvent(this, PROJECT_FILE, null, this.currentProject);
        for (PropertyChangeListener pcl : this.listeners) {
            pcl.propertyChange(pce);
        }
    }

    public BlueProject findProjectFromFile(File temp) {
        if (temp == null || !temp.exists() || temp.isDirectory()) {
            return null;
        }
        for (BlueProject project : this.projects) {
            if (!temp.equals(project.getDataFile())) continue;
            return project;
        }
        return null;
    }

    public void save() {
        if (this.getCurrentProject().getDataFile() != null) {
            try (PrintWriter out = new PrintWriter(new FileWriter(this.getCurrentProject().getDataFile()));){
                out.print(this.getCurrentProject().getData().saveAsXML().toString());
                out.flush();
            }
            catch (IOException ioe) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)("Could not save file:\n\n" + ioe.getLocalizedMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StatusDisplayer.getDefault().setStatusText("File saved: " + this.getCurrentProject().getDataFile().getName());
        } else {
            this.saveAs();
        }
    }

    public boolean saveAs() {
        FileChooserManager fcm = FileChooserManager.getDefault();
        if (this.getCurrentProject().getDataFile() != null) {
            fcm.setSelectedFile(this.getClass(), this.getCurrentProject().getDataFile());
        } else {
            fcm.setSelectedFile(this.getClass(), new File(GeneralSettings.getInstance().getDefaultDirectory() + File.separator + "default.blue"));
        }
        File rValue = fcm.showSaveDialog(this.getClass(), (Component)WindowManager.getDefault().getMainWindow());
        if (rValue != null) {
            Object retVal;
            File temp = rValue;
            if (!temp.getName().trim().endsWith(".blue")) {
                temp = new File(temp.getAbsolutePath() + ".blue");
            }
            if (temp.exists()) {
                NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)("Are you sure you would like to overwite the project file: " + temp.getAbsolutePath()), "Overwrite Project?");
                retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (retVal != NotifyDescriptor.YES_OPTION) {
                    return false;
                }
            }
            if (this.getCurrentProject().isOpenedFromTempFile()) {
                this.getCurrentProject().getTempFile().delete();
                this.getCurrentProject().setOpenedFromTempFile(false);
            }
            try {
                PrintWriter out = new PrintWriter(new FileWriter(temp));
                retVal = null;
                try {
                    BlueData data = this.getCurrentProject().getData();
                    out.print(data.saveAsXML().toString());
                    out.flush();
                }
                catch (Throwable throwable) {
                    retVal = throwable;
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        if (retVal != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)retVal).addSuppressed(throwable);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)("Could not save file:\n\n" + e.getLocalizedMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            StatusDisplayer.getDefault().setStatusText("File saved: " + temp.getName());
            RecentProjectsList.getInstance().addFile(temp.getAbsolutePath());
            this.getCurrentProject().setDataFile(temp);
            BlueSystem.setCurrentProjectDirectory((File)temp.getParentFile());
            temp = null;
            this.fireProjectFileChanged();
            return true;
        }
        return false;
    }

    public boolean closeAllFiles() {
        while (this.projects.size() > 0) {
            if (this.saveCheck()) {
                int index = this.projects.indexOf(this.currentProject);
                this.projects.remove(this.currentProject);
                if (this.currentProject.getTempFile() != null) {
                    this.currentProject.getTempFile().delete();
                }
                if (this.projects.size() == 0) {
                    return true;
                }
                if (index >= this.projects.size()) {
                    this.setCurrentProject(this.projects.get(this.projects.size() - 1));
                    continue;
                }
                this.setCurrentProject(this.projects.get(index));
                continue;
            }
            return false;
        }
        return true;
    }

    public BlueProject getProject(int i) {
        return this.projects.get(i);
    }

    private boolean saveCheck() {
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)"Do you wish to save the current project?", "Save Project?");
        Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (retVal == NotifyDescriptor.YES_OPTION) {
            if (this.getCurrentProject().getDataFile() != null) {
                this.save();
                return true;
            }
            return this.saveAs();
        }
        return retVal == NotifyDescriptor.NO_OPTION;
    }

    public void selectNextProject() {
        if (this.projects.size() < 2 || this.currentProject == null) {
            return;
        }
        int index = this.projects.indexOf(this.currentProject) + 1;
        if (index >= this.projects.size()) {
            index = 0;
        }
        this.setCurrentProject(this.projects.get(index));
    }

    public void selectPreviousProject() {
        if (this.projects.size() < 2 || this.currentProject == null) {
            return;
        }
        int index = this.projects.indexOf(this.currentProject) - 1;
        if (index < 0) {
            index = this.projects.size() - 1;
        }
        this.setCurrentProject(this.projects.get(index));
    }
}

