/*
 * Decompiled with CFR 0.152.
 */
package blue.utility.midi;

import blue.SoundLayer;
import blue.soundObject.GenericScore;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.utilities.MidiUtilities;
import blue.utility.ScoreUtilities;
import blue.utility.midi.MidiImportSettings;
import blue.utility.midi.MidiImportSettingsDialog;
import blue.utility.midi.TrackImportSettings;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class MidiImportUtilities {
    private static final String NOTE_TEMPLATE = "i<INSTR_ID> <START> <DUR> <KEY> <VELOCITY>";

    public static PolyObject convertMidiFile(Frame root, File midiFile) throws NoteParseException {
        if (midiFile == null || !midiFile.exists()) {
            return null;
        }
        Sequence sequence = null;
        try {
            sequence = MidiSystem.getSequence(midiFile);
        }
        catch (InvalidMidiDataException imde) {
            imde.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (sequence == null) {
            return null;
        }
        PolyObject pObj = new PolyObject(true);
        Track[] tracks = sequence.getTracks();
        double divType = sequence.getDivisionType();
        if (divType == 0.0) {
            divType = 1.0;
        }
        double ticksLength = sequence.getResolution();
        MidiImportSettings settings = MidiImportUtilities.getMidiImportSettings(tracks);
        if (settings.getRowCount() == 0) {
            return null;
        }
        boolean retVal = MidiImportSettingsDialog.ask(root, settings);
        if (!retVal) {
            return null;
        }
        for (int i = 0; i < tracks.length; ++i) {
            Track track;
            NoteList nl;
            TrackImportSettings trSettings = settings.getTrackSettingsForTrackNum(i);
            if (trSettings == null || (nl = MidiImportUtilities.getNoteListForTrack(track = tracks[i], divType, ticksLength, trSettings.getNoteTemplate(), trSettings.getInstrId())) == null || nl.size() == 0) continue;
            GenericScore genSco = new GenericScore();
            if (trSettings.isTrim()) {
                double start = ((Note)nl.get(0)).getStartTime();
                genSco.setStartTime(start);
                ScoreUtilities.normalizeNoteList((NoteList)nl);
            } else {
                genSco.setStartTime(0.0);
            }
            genSco.setSubjectiveDuration(ScoreUtilities.getTotalDuration((NoteList)nl));
            genSco.setText(nl.toString());
            genSco.setName("Track " + i);
            SoundLayer sLayer = pObj.newLayerAt(-1);
            sLayer.add((SoundObject)genSco);
        }
        return pObj;
    }

    private static NoteList getNoteListForTrack(Track track, double divType, double ticksLength, String template, String instrId) throws NoteParseException {
        if (track.size() == 0) {
            return null;
        }
        MNote[] notes = new MNote[128];
        for (int j = 0; j < notes.length; ++j) {
            notes[j] = new MNote();
        }
        NoteList nl = new NoteList();
        block5: for (int j = 0; j < track.size(); ++j) {
            MidiEvent me = track.get(j);
            MidiMessage message = me.getMessage();
            if (!(message instanceof ShortMessage)) continue;
            ShortMessage shortMsg = (ShortMessage)message;
            double time = (double)me.getTick() / ticksLength * divType;
            switch (shortMsg.getCommand()) {
                case 144: {
                    int noteNum = shortMsg.getData1();
                    int velocity = shortMsg.getData2();
                    MNote n = notes[noteNum];
                    if (velocity > 0) {
                        n.start = time;
                        n.velocity = velocity;
                        continue block5;
                    }
                    double start = n.start;
                    double duration = time - n.start;
                    String note = MidiUtilities.processNoteTemplate((String)template, (String)instrId, (double)start, (double)duration, (int)noteNum, (int)n.velocity);
                    nl.add((Object)Note.createNote((String)note));
                    n.clear();
                    continue block5;
                }
                case 128: {
                    int noteNum = shortMsg.getData1();
                    int velocity = shortMsg.getData2();
                    MNote n = notes[noteNum];
                    double start = n.start;
                    double duration = time - n.start;
                    String note = MidiUtilities.processNoteTemplate((String)template, (String)instrId, (double)start, (double)duration, (int)noteNum, (int)n.velocity);
                    nl.add((Object)Note.createNote((String)note));
                    n.clear();
                }
            }
        }
        return nl;
    }

    private static MidiImportSettings getMidiImportSettings(Track[] tracks) {
        MidiImportSettings settings = new MidiImportSettings();
        for (int i = 0; i < tracks.length; ++i) {
            Track track = tracks[i];
            boolean containsNotes = false;
            for (int j = 0; j < track.size(); ++j) {
                MidiEvent me = track.get(j);
                MidiMessage message = me.getMessage();
                if (!(message instanceof ShortMessage)) continue;
                ShortMessage shortMsg = (ShortMessage)message;
                switch (shortMsg.getCommand()) {
                    case 144: {
                        int velocity = shortMsg.getData2();
                        if (velocity != 0) break;
                        containsNotes = true;
                        break;
                    }
                    case 128: {
                        containsNotes = true;
                    }
                }
                if (containsNotes) break;
            }
            if (!containsNotes) continue;
            TrackImportSettings trSettings = new TrackImportSettings();
            String instrId = Integer.toString(i);
            trSettings.setInstrId(instrId);
            trSettings.setTrackNumber(i);
            trSettings.setNoteTemplate(NOTE_TEMPLATE);
            settings.addTrackImportSetting(trSettings);
        }
        return settings;
    }

    public static double cpsmid(int midi) {
        return 440.0 * Math.exp(Math.log(2.0) * ((double)(midi - 69) / 12.0));
    }

    private static class MNote {
        public int velocity = -1;
        public double start = -1.0;

        private MNote() {
        }

        public void clear() {
            this.velocity = -1;
            this.start = -1.0;
        }
    }
}

