/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class TclDouble
implements InternalRep {
    private double value;

    private TclDouble(double i) {
        this.value = i;
    }

    private TclDouble(Interp interp, String str) throws TclException {
        this.value = Util.getDouble((Interp)interp, (String)str);
    }

    public InternalRep duplicate() {
        return new TclDouble(this.value);
    }

    public void dispose() {
    }

    public static TclObject newInstance(double d) {
        return new TclObject(new TclDouble(d));
    }

    private static void setDoubleFromAny(Interp interp, TclObject tobj) throws TclException {
        InternalRep rep = tobj.getInternalRep();
        if (!(rep instanceof TclDouble)) {
            if (rep instanceof TclBoolean) {
                boolean b = TclBoolean.get(interp, tobj);
                if (b) {
                    tobj.setInternalRep(new TclDouble(1.0));
                } else {
                    tobj.setInternalRep(new TclDouble(0.0));
                }
            } else if (rep instanceof TclInteger) {
                int i = TclInteger.get(interp, tobj);
                tobj.setInternalRep(new TclDouble(i));
            } else {
                tobj.setInternalRep(new TclDouble(interp, tobj.toString()));
            }
        }
    }

    public static double get(Interp interp, TclObject tobj) throws TclException {
        TclDouble tdouble;
        InternalRep rep = tobj.getInternalRep();
        if (!(rep instanceof TclDouble)) {
            TclDouble.setDoubleFromAny(interp, tobj);
            tdouble = (TclDouble)tobj.getInternalRep();
        } else {
            tdouble = (TclDouble)rep;
        }
        return tdouble.value;
    }

    public static void set(TclObject tobj, double d) {
        tobj.invalidateStringRep();
        InternalRep rep = tobj.getInternalRep();
        if (rep instanceof TclDouble) {
            TclDouble tdouble = (TclDouble)rep;
            tdouble.value = d;
        } else {
            tobj.setInternalRep(new TclDouble(d));
        }
    }

    public String toString() {
        return Util.printDouble((double)this.value);
    }
}

