/*
 * Decompiled with CFR 0.152.
 */
package blue.osc;

import blue.osc.OSCManager;
import blue.osc.OSCOptionsPanelController;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class OSCPanel
extends JPanel {
    private final OSCOptionsPanelController controller;
    private JLabel serverPortLabel;
    private JSpinner serverPortSpinner;

    OSCPanel(OSCOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.serverPortSpinner.addChangeListener(e -> this.controller.changed());
    }

    private void initComponents() {
        this.serverPortLabel = new JLabel();
        this.serverPortSpinner = new JSpinner();
        Mnemonics.setLocalizedText((JLabel)this.serverPortLabel, (String)NbBundle.getMessage(OSCPanel.class, (String)"OSCPanel.serverPortLabel.text"));
        this.serverPortSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.serverPortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serverPortSpinner, -2, 132, -2).addContainerGap(188, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.serverPortLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.serverPortSpinner, GroupLayout.Alignment.LEADING)).addContainerGap(166, Short.MAX_VALUE)));
    }

    void load() {
        Preferences prefs = NbPreferences.forModule(OSCManager.class);
        this.serverPortSpinner.setValue(prefs.getInt("serverPort", 8000));
    }

    void store() {
        Preferences prefs = NbPreferences.forModule(OSCManager.class);
        prefs.putInt("serverPort", ((SpinnerNumberModel)this.serverPortSpinner.getModel()).getNumber().intValue());
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    boolean valid() {
        return true;
    }
}

