/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import blue.soundObject.editor.ceciliaModule.Thumb;
import blue.utility.GUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FloatSlider
extends JComponent {
    private static int SLIDER_HEIGHT = 14;
    private ArrayList listeners = new ArrayList();
    private ArrayList actionListeners = new ArrayList();
    ChangeEvent changeEvent = new ChangeEvent(this);
    String name = "";
    float value = 0.0f;
    float rangeMax = 1.0f;
    float rangeMin = 0.0f;
    float resolution = 0.1f;
    boolean updatingValue = false;
    Thumb thumb;

    public FloatSlider() {
        this.setPreferredSize(new Dimension(200, 15));
        this.setLayout(null);
        this.thumb = new Thumb();
        this.thumb.setLocation(1, 1);
        this.thumb.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (!FloatSlider.this.updatingValue && FloatSlider.this.thumb.isEditingValue()) {
                    FloatSlider.this.updateValue();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FloatSlider.this.updateThumb();
                FloatSlider.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                FloatSlider.this.nudge(x, y);
            }
        });
        this.add(this.thumb);
    }

    private void updateValue() {
        int range = this.getWidth() - 2 - this.thumb.getWidth();
        int loc = this.thumb.getX() - 1;
        this.value = (float)loc / (float)range;
        this.fireChangeEvent(this.changeEvent);
    }

    private void updateThumb() {
        int range = this.getWidth() - 2 - this.thumb.getWidth();
        int newX = (int)(this.value * (float)range) + 1;
        int newY = this.getHeight() / 2 - this.thumb.getHeight() / 2;
        this.thumb.setLocation(newX, newY);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        int center = h / 2;
        int top = center - SLIDER_HEIGHT / 2;
        int bottom = center + SLIDER_HEIGHT / 2;
        g.setColor(Color.BLACK);
        g.drawLine(0, top, w, top);
        g.drawLine(0, top, 0, bottom);
        g.setColor(UIManager.getColor("ScrollBar.trackHighlight"));
        g.drawLine(0, bottom, w - 1, bottom);
        g.drawLine(w - 1, top, w - 1, bottom);
    }

    public void setValue(float value) {
        this.updatingValue = true;
        this.value = value;
        this.updateThumb();
        this.updatingValue = false;
    }

    public float getValue() {
        return this.value;
    }

    public float getValueFromRange() {
        return this.value * (this.rangeMax - this.rangeMin) + this.rangeMin;
    }

    private void fireChangeEvent(ChangeEvent ce) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ce);
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.listeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    private void fireActionEvent(ActionEvent ae) {
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(ae);
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        GUI.showComponentAsStandalone((Component)new FloatSlider(), (String)"Float Slider", (boolean)true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public float getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMax(float rangeMax) {
        this.rangeMax = rangeMax;
    }

    public float getRangeMin() {
        return this.rangeMin;
    }

    public void setRangeMin(float rangeMin) {
        this.rangeMin = rangeMin;
    }

    public float getResolution() {
        return this.resolution;
    }

    public void setResolution(float resolution) {
        this.resolution = resolution;
    }

    private void nudge(int x, int y) {
        if (y < this.thumb.getY() || y > this.thumb.getY() + this.thumb.getHeight()) {
            return;
        }
        if (x < this.thumb.getX()) {
            ActionEvent ae = new ActionEvent(this, 1001, "nudgeLeft");
            this.fireActionEvent(ae);
        } else {
            ActionEvent ae = new ActionEvent(this, 1001, "nudgeRight");
            this.fireActionEvent(ae);
        }
    }
}

