/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.core;

import blue.CompileData;
import blue.automation.ParameterIdList;
import blue.mixer.Channel;
import blue.mixer.Mixer;
import blue.orchestra.GenericInstrument;
import blue.orchestra.Instrument;
import blue.score.ScoreObject;
import blue.score.layers.AutomatableLayer;
import blue.score.layers.ScoreObjectLayer;
import blue.score.layers.audio.core.AudioClip;
import blue.score.layers.audio.core.AudioLayerListener;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObjectException;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.dgc.VMID;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AudioLayer
extends ArrayList<AudioClip>
implements ScoreObjectLayer<AudioClip>,
AutomatableLayer {
    public static int HEIGHT_MAX_INDEX = 9;
    private static MessageFormat INSTR_TEXT = null;
    private String name = "";
    private boolean muted = false;
    private boolean solo = false;
    private String uniqueId;
    private int heightIndex = 0;
    private ParameterIdList automationParameters;
    private transient List<PropertyChangeListener> propListeners = null;
    private transient List<AudioLayerListener> layerListeners = null;

    public AudioLayer() {
        this.uniqueId = new VMID().toString();
        this.automationParameters = new ParameterIdList();
    }

    public AudioLayer(AudioLayer al) {
        super(al.size());
        this.uniqueId = al.uniqueId;
        this.automationParameters = new ParameterIdList(al.automationParameters);
        this.name = al.name;
        this.muted = al.muted;
        this.solo = al.solo;
        this.heightIndex = al.heightIndex;
        for (AudioClip ac : al) {
            this.add(ac.deepCopy());
        }
    }

    @Override
    public boolean add(AudioClip e) {
        boolean retVal = super.add(e);
        this.fireAudioClipAdded(e);
        return retVal;
    }

    public boolean remove(ScoreObject o) {
        if (!(o instanceof AudioClip)) {
            return false;
        }
        boolean retVal = super.remove(o);
        if (retVal) {
            this.fireAudioClipRemoved((AudioClip)o);
        }
        return retVal;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        String string = this.name = name == null ? "" : name;
        if (!this.name.equals(oldName)) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "name", oldName, name));
        }
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    public boolean isSolo() {
        return this.solo;
    }

    public void setSolo(boolean solo) {
        this.solo = solo;
    }

    public int getHeightIndex() {
        return this.heightIndex;
    }

    public void setHeightIndex(int heightIndex) {
        if (this.heightIndex == heightIndex) {
            return;
        }
        int oldHeight = this.heightIndex;
        this.heightIndex = heightIndex;
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "heightIndex", new Integer(oldHeight), new Integer(heightIndex));
        this.firePropertyChangeEvent(pce);
    }

    public int getAudioLayerHeight() {
        return (this.heightIndex + 1) * 22;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public ParameterIdList getAutomationParameters() {
        return this.automationParameters;
    }

    public Element saveAsXML() {
        Element retVal = new Element("audioLayer");
        retVal.setAttribute("name", this.getName());
        retVal.setAttribute("muted", Boolean.toString(this.isMuted()));
        retVal.setAttribute("solo", Boolean.toString(this.isSolo()));
        retVal.setAttribute("heightIndex", Integer.toString(this.getHeightIndex()));
        retVal.setAttribute("uniqueId", this.uniqueId);
        for (AudioClip clip : this) {
            retVal.addElement(clip.saveAsXML());
        }
        for (String id : this.automationParameters) {
            retVal.addElement("parameterId").setText(id);
        }
        return retVal;
    }

    public static AudioLayer loadFromXML(Element data) {
        String heightIndexStr;
        AudioLayer layer = new AudioLayer();
        layer.setName(data.getAttributeValue("name"));
        layer.setMuted(Boolean.valueOf(data.getAttributeValue("muted")));
        layer.setSolo(Boolean.valueOf(data.getAttributeValue("solo")));
        if (data.getAttribute("uniqueId") != null) {
            layer.uniqueId = data.getAttributeValue("uniqueId");
        }
        if ((heightIndexStr = data.getAttributeValue("heightIndex")) != null) {
            layer.setHeightIndex(Integer.parseInt(heightIndexStr));
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            switch (node.getName()) {
                case "audioClip": {
                    layer.add(AudioClip.loadFromXML(node));
                    break;
                }
                case "parameterId": {
                    String id = node.getTextString();
                    layer.automationParameters.addParameterId(id);
                }
            }
        }
        return layer;
    }

    void clearListeners() {
        if (this.propListeners != null) {
            this.propListeners.clear();
            this.propListeners = null;
        }
        if (this.layerListeners != null) {
            this.layerListeners.clear();
            this.layerListeners = null;
        }
    }

    protected String getInstrumentText(String var1, String var2) {
        if (INSTR_TEXT == null) {
            StringBuilder str = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("blue/score/layers/audio/core/playback_instrument.orc")));){
                String line;
                while ((line = br.readLine()) != null) {
                    str.append(line).append("\n");
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("[error] AudioLayer could not load instr text");
            }
            INSTR_TEXT = new MessageFormat(str.toString());
        }
        return INSTR_TEXT.format(new Object[]{var1, var2});
    }

    protected int generateInstrumentForAudioLayer(CompileData compileData) {
        if (compileData.getCompilationVariable((Object)this.uniqueId) != null) {
            return (Integer)compileData.getCompilationVariable((Object)this.uniqueId);
        }
        Map assignments = compileData.getChannelIdAssignments();
        Channel c = null;
        for (Channel channel : assignments.keySet()) {
            if (!this.uniqueId.equals(channel.getAssociation())) continue;
            c = channel;
        }
        GenericInstrument instr = new GenericInstrument();
        StringBuilder str = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("playback_instrument.orc")));){
            String line;
            while ((line = br.readLine()) != null) {
                str.append(line).append("\n");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("[error] AudioLayer could not load instr text");
        }
        if (c == null) {
            throw new RuntimeException("Error: could not find Mixer Channels for Audio layer");
        }
        int channelId = (Integer)assignments.get(c);
        String var1 = Mixer.getChannelVar((int)channelId, (int)0);
        String var2 = Mixer.getChannelVar((int)channelId, (int)1);
        instr.setText(this.getInstrumentText(var1, var2));
        int instrId = compileData.addInstrument((Instrument)instr);
        compileData.setCompilationVariable((Object)this.uniqueId, (Object)instrId);
        return instrId;
    }

    NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        if (compileData.getCompilationVariable((Object)"BLUE_FADE_UDO") == null) {
            StringBuilder str = new StringBuilder();
            try {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("blue/score/layers/audio/core/blue_fade.udo")));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        str.append(line).append("\n");
                    }
                }
                compileData.appendGlobalOrc(str.toString());
            }
            catch (IOException ioe) {
                throw new RuntimeException("[error] AudioLayer could not load blue_fade.udo");
            }
            compileData.setCompilationVariable((Object)"BLUE_FADE_UDO", new Object());
        }
        NoteList notes = new NoteList();
        int instrId = this.generateInstrumentForAudioLayer(compileData);
        boolean usesEndTime = endTime > startTime;
        double adjustedEndTime = endTime - startTime;
        for (AudioClip clip : this) {
            double clipStart = clip.getStartTime();
            double clipFileStart = clip.getFileStartTime();
            double clipDur = clip.getSubjectiveDuration();
            double clipEnd = clipStart + clipDur;
            if (clipEnd <= startTime || usesEndTime && clipStart >= endTime) continue;
            Note n = Note.createNote((int)11);
            double adjustedStart = clipStart - startTime;
            double adjustedEnd = clipEnd - startTime;
            double startOffset = Math.max(startTime - clipStart, 0.0);
            double newStart = Math.max(adjustedStart, 0.0);
            double newEnd = clipEnd - startTime;
            double newDuration = usesEndTime && newEnd > adjustedEndTime ? adjustedEndTime - newStart : newEnd - newStart;
            n.setPField(Integer.toString(instrId), 1);
            n.setStartTime(newStart);
            n.setSubjectiveDuration(newDuration);
            n.setPField("\"" + clip.getAudioFile().getAbsolutePath() + "\"", 4);
            n.setPField(Double.toString(clipFileStart), 5);
            n.setPField(Double.toString(startOffset), 6);
            n.setPField(Double.toString(clipDur), 7);
            int fadeType = clip.getFadeInType().ordinal();
            n.setPField(Integer.toString(fadeType), 8);
            n.setPField(Double.toString(clip.getFadeIn()), 9);
            fadeType = clip.getFadeOutType().ordinal();
            n.setPField(Integer.toString(fadeType), 10);
            n.setPField(Double.toString(clip.getFadeOut()), 11);
            notes.add((Object)n);
        }
        return notes;
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.propListeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.propListeners) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propListeners == null) {
            this.propListeners = Collections.synchronizedList(new ArrayList());
        }
        if (this.propListeners.contains(pcl)) {
            return;
        }
        this.propListeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propListeners == null) {
            return;
        }
        this.propListeners.remove(pcl);
    }

    protected void fireAudioClipAdded(AudioClip clip) {
        if (this.layerListeners == null) {
            return;
        }
        for (AudioLayerListener listener : this.layerListeners) {
            listener.audioClipAdded(this, clip);
        }
    }

    protected void fireAudioClipRemoved(AudioClip clip) {
        if (this.layerListeners == null) {
            return;
        }
        for (AudioLayerListener listener : this.layerListeners) {
            listener.audioClipRemoved(this, clip);
        }
    }

    public void addAudioLayerListener(AudioLayerListener listener) {
        if (this.layerListeners == null) {
            this.layerListeners = Collections.synchronizedList(new ArrayList());
        }
        if (this.layerListeners.contains(listener)) {
            return;
        }
        this.layerListeners.add(listener);
    }

    public void removeAudioLayerListener(AudioLayerListener listener) {
        if (this.layerListeners == null) {
            return;
        }
        this.layerListeners.remove(listener);
    }

    public int getLayerHeight() {
        return 22 * (this.heightIndex + 1);
    }

    public boolean accepts(ScoreObject object) {
        return object instanceof AudioClip;
    }

    public boolean contains(ScoreObject object) {
        if (!this.accepts(object)) {
            return false;
        }
        return super.contains(object);
    }

    public double getMaxTime() {
        double max = 0.0;
        for (AudioClip clip : this) {
            double end = clip.getStartTime() + clip.getSubjectiveDuration();
            if (!(end > max)) continue;
            max = end;
        }
        return max;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    public void clearScoreObjects() {
        this.clear();
    }

    public AudioLayer deepCopy() {
        return new AudioLayer(this);
    }
}

