/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http4;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.util.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlFileListParser {
    private static final Pattern APACHE_INDEX_SKIP = Pattern.compile("\\?[CDMNS]=.*");
    private static final Pattern URLS_WITH_PATHS = Pattern.compile("/[^/]*/");
    private static final Pattern URLS_TO_PARENT = Pattern.compile("\\.\\./");
    private static final Pattern MAILTO_URLS = Pattern.compile("mailto:.*");
    private static final Pattern[] SKIPS = new Pattern[]{APACHE_INDEX_SKIP, URLS_WITH_PATHS, URLS_TO_PARENT, MAILTO_URLS};

    public static List<String> parseFileList(String baseurl, InputStream stream) throws TransferFailedException {
        try {
            URI baseURI = new URI(baseurl);
            String content = IOUtils.toString((InputStream)stream, (String)"utf-8");
            Document doc = Jsoup.parse((String)content, (String)baseurl);
            Elements links = doc.getElementsByTag("a");
            HashSet<String> results = new HashSet<String>();
            for (int lx = 0; lx < links.size(); ++lx) {
                String clean;
                Element link = links.get(lx);
                String target = link.attr("href");
                if (target == null || !HtmlFileListParser.isAcceptableLink(clean = HtmlFileListParser.cleanLink(baseURI, target))) continue;
                results.add(clean);
            }
            return new ArrayList<String>(results);
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException("Unable to parse as base URI: " + baseurl, (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("I/O error reading HTML listing of artifacts: " + e.getMessage(), (Throwable)e);
        }
    }

    private static String cleanLink(URI baseURI, String link) {
        if (StringUtils.isEmpty((String)link)) {
            return "";
        }
        String ret = link;
        try {
            URI relativeURI;
            URI linkuri = new URI(ret);
            if (link.startsWith("/")) {
                linkuri = baseURI.resolve(linkuri);
            }
            if ((ret = (relativeURI = baseURI.relativize(linkuri).normalize()).toASCIIString()).startsWith(baseURI.getPath())) {
                ret = ret.substring(baseURI.getPath().length());
            }
            ret = URLDecoder.decode(ret, "UTF-8");
        }
        catch (URISyntaxException e) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    private static boolean isAcceptableLink(String link) {
        if (StringUtils.isEmpty((String)link)) {
            return false;
        }
        for (int i = 0; i < SKIPS.length; ++i) {
            if (!SKIPS[i].matcher(link).find()) continue;
            return false;
        }
        return true;
    }
}

