/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.text.ParsePosition;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class BinaryCmd
implements Command {
    private static final String[] validCmds = new String[]{"format", "scan"};
    private static final int CMD_FORMAT = 0;
    private static final int CMD_SCAN = 1;
    private static final int BINARY_ALL = -1;
    private static final int BINARY_NOCOUNT = -2;
    private static final char FORMAT_END = ' ';

    BinaryCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        char[] format = null;
        int value = 0;
        int size = 0;
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int cmdIndex = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])validCmds, (String)"option", (int)0);
        switch (cmdIndex) {
            case 0: {
                int cursor;
                char cmd;
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "formatString ?arg arg ...?");
                }
                format = argv[2].toString().toCharArray();
                int arg = 3;
                int length = 0;
                int offset = 0;
                ParsePosition parsePos = new ParsePosition(0);
                block48: while ((cmd = this.GetFormatSpec(format, parsePos)) != ' ') {
                    int count = this.GetFormatCount(format, parsePos);
                    switch (cmd) {
                        case 'A': 
                        case 'B': 
                        case 'H': 
                        case 'a': 
                        case 'b': 
                        case 'h': {
                            if (arg >= argv.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            if (count == -1) {
                                count = TclByteArray.getLength(interp, argv[arg]);
                            } else if (count == -2) {
                                count = 1;
                            }
                            ++arg;
                            switch (cmd) {
                                case 'A': 
                                case 'a': {
                                    offset += count;
                                    break;
                                }
                                case 'B': 
                                case 'b': {
                                    offset += (count + 7) / 8;
                                    break;
                                }
                                case 'H': 
                                case 'h': {
                                    offset += (count + 1) / 2;
                                }
                            }
                            continue block48;
                        }
                        case 'I': 
                        case 'S': 
                        case 'c': 
                        case 'd': 
                        case 'f': 
                        case 'i': 
                        case 's': {
                            if (arg >= argv.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            switch (cmd) {
                                case 'c': {
                                    size = 1;
                                    break;
                                }
                                case 'S': 
                                case 's': {
                                    size = 2;
                                    break;
                                }
                                case 'I': 
                                case 'i': {
                                    size = 4;
                                    break;
                                }
                                case 'f': {
                                    size = 4;
                                    break;
                                }
                                case 'd': {
                                    size = 8;
                                }
                            }
                            if (count == -2) {
                                ++arg;
                                count = 1;
                            } else {
                                int listc = TclList.getLength(interp, argv[arg++]);
                                if (count == -1) {
                                    count = listc;
                                } else if (count > listc) {
                                    throw new TclException(interp, "number of elements in list does not match count");
                                }
                            }
                            offset += count * size;
                            continue block48;
                        }
                        case 'x': {
                            if (count == -1) {
                                throw new TclException(interp, "cannot use \"*\" in format string with \"x\"");
                            }
                            if (count == -2) {
                                count = 1;
                            }
                            offset += count;
                            continue block48;
                        }
                        case 'X': {
                            if (count == -2) {
                                count = 1;
                            }
                            if (count > offset || count == -1) {
                                count = offset;
                            }
                            if (offset > length) {
                                length = offset;
                            }
                            offset -= count;
                            continue block48;
                        }
                        case '@': {
                            if (offset > length) {
                                length = offset;
                            }
                            if (count == -1) {
                                offset = length;
                                continue block48;
                            }
                            if (count == -2) {
                                BinaryCmd.alephWithoutCount(interp);
                                continue block48;
                            }
                            offset = count;
                            continue block48;
                        }
                    }
                    BinaryCmd.badField(interp, cmd);
                }
                if (offset > length) {
                    length = offset;
                }
                if (length == 0) {
                    return;
                }
                TclObject resultObj = TclByteArray.newInstance();
                byte[] resultBytes = TclByteArray.setLength(interp, resultObj, length);
                interp.setResult(resultObj);
                arg = 3;
                int maxPos = cursor = 0;
                parsePos.setIndex(0);
                block49: while ((cmd = this.GetFormatSpec(format, parsePos)) != ' ') {
                    int count = this.GetFormatCount(format, parsePos);
                    if (count == 0 && cmd != '@') {
                        ++arg;
                        continue;
                    }
                    switch (cmd) {
                        case 'A': 
                        case 'a': {
                            int pad = cmd == 'a' ? 0 : 32;
                            byte[] bytes = TclByteArray.getBytes(interp, argv[arg++]);
                            length = bytes.length;
                            if (count == -1) {
                                count = length;
                            } else if (count == -2) {
                                count = 1;
                            }
                            if (length >= count) {
                                System.arraycopy(bytes, 0, resultBytes, cursor, count);
                            } else {
                                System.arraycopy(bytes, 0, resultBytes, cursor, length);
                                for (int ix = 0; ix < count - length; ++ix) {
                                    resultBytes[cursor + length + ix] = pad;
                                }
                            }
                            cursor += count;
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            char[] str = argv[arg++].toString().toCharArray();
                            if (count == -1) {
                                count = str.length;
                            } else if (count == -2) {
                                count = 1;
                            }
                            int last = cursor + (count + 7) / 8;
                            if (count > str.length) {
                                count = str.length;
                            }
                            if (cmd == 'B') {
                                for (offset = 0; offset < count; ++offset) {
                                    value <<= 1;
                                    if (str[offset] == '1') {
                                        value |= 1;
                                    } else if (str[offset] != '0') {
                                        BinaryCmd.expectedButGot(interp, "binary", new String(str));
                                    }
                                    if ((offset + 1) % 8 != 0) continue;
                                    resultBytes[cursor++] = (byte)value;
                                    value = 0;
                                }
                            } else {
                                for (offset = 0; offset < count; ++offset) {
                                    value >>= 1;
                                    if (str[offset] == '1') {
                                        value |= 0x80;
                                    } else if (str[offset] != '0') {
                                        BinaryCmd.expectedButGot(interp, "binary", new String(str));
                                    }
                                    if ((offset + 1) % 8 != 0) continue;
                                    resultBytes[cursor++] = (byte)value;
                                    value = 0;
                                }
                            }
                            if (offset % 8 != 0) {
                                value = cmd == 'B' ? (value <<= 8 - offset % 8) : (value >>= 8 - offset % 8);
                                resultBytes[cursor++] = (byte)value;
                            }
                            while (cursor < last) {
                                resultBytes[cursor++] = 0;
                            }
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            int c;
                            char[] str = argv[arg++].toString().toCharArray();
                            if (count == -1) {
                                count = str.length;
                            } else if (count == -2) {
                                count = 1;
                            }
                            int last = cursor + (count + 1) / 2;
                            if (count > str.length) {
                                count = str.length;
                            }
                            if (cmd == 'H') {
                                for (offset = 0; offset < count; ++offset) {
                                    value <<= 4;
                                    c = Character.digit(str[offset], 16);
                                    if (c < 0) {
                                        BinaryCmd.expectedButGot(interp, "hexadecimal", new String(str));
                                    }
                                    value |= c & 0xF;
                                    if (offset % 2 == 0) continue;
                                    resultBytes[cursor++] = (byte)value;
                                    value = 0;
                                }
                            } else {
                                for (offset = 0; offset < count; ++offset) {
                                    value >>= 4;
                                    c = Character.digit(str[offset], 16);
                                    if (c < 0) {
                                        BinaryCmd.expectedButGot(interp, "hexadecimal", new String(str));
                                    }
                                    value |= c << 4 & 0xF0;
                                    if (offset % 2 == 0) continue;
                                    resultBytes[cursor++] = (byte)value;
                                    value = 0;
                                }
                            }
                            if (offset % 2 != 0) {
                                value = cmd == 'H' ? (value <<= 4) : (value >>= 4);
                                resultBytes[cursor++] = (byte)value;
                            }
                            while (cursor < last) {
                                resultBytes[cursor++] = 0;
                            }
                            break;
                        }
                        case 'I': 
                        case 'S': 
                        case 'c': 
                        case 'd': 
                        case 'f': 
                        case 'i': 
                        case 's': {
                            TclObject[] listv;
                            if (count == -2) {
                                listv = new TclObject[]{argv[arg++]};
                                count = 1;
                            } else {
                                listv = TclList.getElements(interp, argv[arg++]);
                                if (count == -1) {
                                    count = listv.length;
                                }
                            }
                            for (int ix = 0; ix < count; ++ix) {
                                cursor = BinaryCmd.FormatNumber(interp, cmd, listv[ix], resultBytes, cursor);
                            }
                            continue block49;
                        }
                        case 'x': {
                            if (count == -2) {
                                count = 1;
                            }
                            for (int ix = 0; ix < count; ++ix) {
                                resultBytes[cursor++] = 0;
                            }
                            continue block49;
                        }
                        case 'X': {
                            if (cursor > maxPos) {
                                maxPos = cursor;
                            }
                            if (count == -2) {
                                count = 1;
                            }
                            if (count == -1 || count > cursor) {
                                cursor = 0;
                                break;
                            }
                            cursor -= count;
                            break;
                        }
                        case '@': {
                            if (cursor > maxPos) {
                                maxPos = cursor;
                            }
                            cursor = count == -1 ? maxPos : count;
                        }
                    }
                }
                break;
            }
            case 1: {
                char cmd;
                if (argv.length < 4) {
                    throw new TclNumArgsException(interp, 2, argv, "value formatString ?varName varName ...?");
                }
                byte[] src = TclByteArray.getBytes(interp, argv[2]);
                int length = src.length;
                format = argv[3].toString().toCharArray();
                int arg = 4;
                boolean cursor = false;
                int offset = 0;
                ParsePosition parsePos = new ParsePosition(0);
                while ((cmd = this.GetFormatSpec(format, parsePos)) != ' ') {
                    int count = this.GetFormatCount(format, parsePos);
                    switch (cmd) {
                        case 'A': 
                        case 'a': {
                            if (arg >= argv.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            if (count == -1) {
                                count = length - offset;
                            } else {
                                if (count == -2) {
                                    count = 1;
                                }
                                if (count > length - offset) break;
                            }
                            if (cmd == 'A') {
                                for (size = count; size > 0 && (src[offset + size - 1] == 0 || src[offset + size - 1] == 32); --size) {
                                }
                            }
                            interp.setVar(argv[arg++], TclByteArray.newInstance(src, offset, size), 0);
                            offset += count;
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            int ix;
                            if (arg >= argv.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            if (count == -1) {
                                count = (length - offset) * 8;
                            } else {
                                if (count == -2) {
                                    count = 1;
                                }
                                if (count > (length - offset) * 8) break;
                            }
                            StringBuffer s = new StringBuffer(count);
                            int thisOffset = offset;
                            if (cmd == 'b') {
                                for (ix = 0; ix < count; ++ix) {
                                    value = ix % 8 != 0 ? (value >>= 1) : src[thisOffset++];
                                    s.append((value & 1) != 0 ? (char)'1' : '0');
                                }
                            } else {
                                for (ix = 0; ix < count; ++ix) {
                                    value = ix % 8 != 0 ? (value <<= 1) : src[thisOffset++];
                                    s.append((value & 0x80) != 0 ? (char)'1' : '0');
                                }
                            }
                            interp.setVar(argv[arg++], TclString.newInstance((String)s.toString()), 0);
                            offset += (count + 7) / 8;
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            int ix;
                            if (arg >= argv.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            if (count == -1) {
                                count = (length - offset) * 2;
                            } else {
                                if (count == -2) {
                                    count = 1;
                                }
                                if (count > (length - offset) * 2) break;
                            }
                            StringBuffer s = new StringBuffer(count);
                            int thisOffset = offset;
                            if (cmd == 'h') {
                                for (ix = 0; ix < count; ++ix) {
                                    value = ix % 2 != 0 ? (value >>= 4) : src[thisOffset++];
                                    s.append(Character.forDigit(value & 0xF, 16));
                                }
                            } else {
                                for (ix = 0; ix < count; ++ix) {
                                    value = ix % 2 != 0 ? (value <<= 4) : src[thisOffset++];
                                    s.append(Character.forDigit(value >> 4 & 0xF, 16));
                                }
                            }
                            interp.setVar(argv[arg++], TclString.newInstance((String)s.toString()), 0);
                            offset += (count + 1) / 2;
                            break;
                        }
                        case 'I': 
                        case 'S': 
                        case 'c': 
                        case 'd': 
                        case 'f': 
                        case 'i': 
                        case 's': {
                            TclObject valueObj;
                            int ix;
                            int thisOffset;
                            if (arg >= argv.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            switch (cmd) {
                                case 'c': {
                                    size = 1;
                                    break;
                                }
                                case 'S': 
                                case 's': {
                                    size = 2;
                                    break;
                                }
                                case 'I': 
                                case 'i': {
                                    size = 4;
                                    break;
                                }
                                case 'f': {
                                    size = 4;
                                    break;
                                }
                                case 'd': {
                                    size = 8;
                                }
                            }
                            if (count == -2) {
                                if (length - offset < size) break;
                                valueObj = BinaryCmd.ScanNumber(src, offset, cmd);
                                offset += size;
                            } else {
                                if (count == -1) {
                                    count = (length - offset) / size;
                                }
                                if (length - offset < count * size) break;
                                valueObj = TclList.newInstance();
                                thisOffset = offset;
                                for (ix = 0; ix < count; ++ix) {
                                    TclList.append(null, valueObj, BinaryCmd.ScanNumber(src, thisOffset, cmd));
                                    thisOffset += size;
                                }
                                offset += count * size;
                            }
                            interp.setVar(argv[arg++], valueObj, 0);
                            break;
                        }
                        case 'x': {
                            if (count == -2) {
                                count = 1;
                            }
                            if (count == -1 || count > length - offset) {
                                offset = length;
                                break;
                            }
                            offset += count;
                            break;
                        }
                        case 'X': {
                            if (count == -2) {
                                count = 1;
                            }
                            if (count == -1 || count > offset) {
                                offset = 0;
                                break;
                            }
                            offset -= count;
                            break;
                        }
                        case '@': {
                            if (count == -2) {
                                BinaryCmd.alephWithoutCount(interp);
                            }
                            if (count == -1 || count > length) {
                                offset = length;
                                break;
                            }
                            offset = count;
                            break;
                        }
                        default: {
                            BinaryCmd.badField(interp, cmd);
                        }
                    }
                }
                interp.setResult(arg - 4);
            }
        }
    }

    private char GetFormatSpec(char[] format, ParsePosition parsePos) {
        int ix;
        for (ix = parsePos.getIndex(); ix < format.length && format[ix] == ' '; ++ix) {
        }
        if (ix >= format.length) {
            parsePos.setIndex(ix);
            return ' ';
        }
        parsePos.setIndex(ix + 1);
        return format[ix++];
    }

    private int GetFormatCount(char[] format, ParsePosition parsePos) {
        int ix = parsePos.getIndex();
        if (ix < format.length && format[ix] == '*') {
            parsePos.setIndex(ix + 1);
            return -1;
        }
        if (ix < format.length && Character.isDigit(format[ix])) {
            int length = 1;
            while (ix + length < format.length && Character.isDigit(format[ix + length])) {
                ++length;
            }
            parsePos.setIndex(ix + length);
            return Integer.parseInt(new String(format, ix, length));
        }
        return -2;
    }

    static int FormatNumber(Interp interp, char type, TclObject src, byte[] resultBytes, int cursor) throws TclException {
        if (type == 'd') {
            double dvalue = TclDouble.get((Interp)interp, (TclObject)src);
            long lvalue = Double.doubleToLongBits(dvalue);
            for (int ix = 7; ix >= 0; --ix) {
                resultBytes[cursor++] = (byte)(lvalue >> ix * 8);
            }
        } else if (type == 'f') {
            float fvalue = (float)TclDouble.get((Interp)interp, (TclObject)src);
            int ivalue = Float.floatToIntBits(fvalue);
            for (int ix = 3; ix >= 0; --ix) {
                resultBytes[cursor++] = (byte)(ivalue >> ix * 8);
            }
        } else {
            int value = TclInteger.get((Interp)interp, (TclObject)src);
            if (type == 'c') {
                resultBytes[cursor++] = (byte)value;
            } else if (type == 's') {
                resultBytes[cursor++] = (byte)value;
                resultBytes[cursor++] = (byte)(value >> 8);
            } else if (type == 'S') {
                resultBytes[cursor++] = (byte)(value >> 8);
                resultBytes[cursor++] = (byte)value;
            } else if (type == 'i') {
                resultBytes[cursor++] = (byte)value;
                resultBytes[cursor++] = (byte)(value >> 8);
                resultBytes[cursor++] = (byte)(value >> 16);
                resultBytes[cursor++] = (byte)(value >> 24);
            } else if (type == 'I') {
                resultBytes[cursor++] = (byte)(value >> 24);
                resultBytes[cursor++] = (byte)(value >> 16);
                resultBytes[cursor++] = (byte)(value >> 8);
                resultBytes[cursor++] = (byte)value;
            }
        }
        return cursor;
    }

    private static TclObject ScanNumber(byte[] src, int pos, int type) {
        switch (type) {
            case 99: {
                return TclInteger.newInstance((int)src[pos]);
            }
            case 115: {
                short value = (short)((src[pos] & 0xFF) + ((src[pos + 1] & 0xFF) << 8));
                return TclInteger.newInstance((int)value);
            }
            case 83: {
                short value = (short)((src[pos + 1] & 0xFF) + ((src[pos] & 0xFF) << 8));
                return TclInteger.newInstance((int)value);
            }
            case 105: {
                int value = (src[pos] & 0xFF) + ((src[pos + 1] & 0xFF) << 8) + ((src[pos + 2] & 0xFF) << 16) + ((src[pos + 3] & 0xFF) << 24);
                return TclInteger.newInstance((int)value);
            }
            case 73: {
                int value = (src[pos + 3] & 0xFF) + ((src[pos + 2] & 0xFF) << 8) + ((src[pos + 1] & 0xFF) << 16) + ((src[pos] & 0xFF) << 24);
                return TclInteger.newInstance((int)value);
            }
            case 102: {
                int value = (src[pos + 3] & 0xFF) + ((src[pos + 2] & 0xFF) << 8) + ((src[pos + 1] & 0xFF) << 16) + ((src[pos] & 0xFF) << 24);
                return TclDouble.newInstance((double)Float.intBitsToFloat(value));
            }
            case 100: {
                long value = (src[pos + 7] & 0xFF) + ((src[pos + 6] & 0xFF) << 8) + ((src[pos + 5] & 0xFF) << 16) + ((src[pos + 4] & 0xFF) << 24) + ((src[pos + 3] & 0xFF) << 32) + ((src[pos + 2] & 0xFF) << 40) + ((src[pos + 1] & 0xFF) << 48) + ((src[pos] & 0xFF) << 56);
                return TclDouble.newInstance((double)Double.longBitsToDouble(value));
            }
        }
        return null;
    }

    private static void missingArg(Interp interp) throws TclException {
        throw new TclException(interp, "not enough arguments for all format specifiers");
    }

    private static void badField(Interp interp, char cmd) throws TclException {
        throw new TclException(interp, "bad field specifier \"" + cmd + "\"");
    }

    private static void alephWithoutCount(Interp interp) throws TclException {
        throw new TclException(interp, "missing count for \"@\" field specifier");
    }

    private static void expectedButGot(Interp interp, String expected, String str) throws TclException {
        throw new TclException(interp, "expected " + expected + " string but got \"" + str + "\" instead");
    }
}

