/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import tcl.lang.ChannelBuffer;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

class TclOutputStream {
    private OutputStream output;
    private char eofChar;
    protected int translation;
    protected String encoding;
    protected CharToByteConverter ctb = null;
    protected int buffering;
    protected boolean blocking;
    protected boolean blocked = false;
    protected int bufSize;
    protected char[] outputStage = null;
    Object encodingState = null;
    boolean encodingStart = true;
    boolean encodingEnd = false;
    ChannelBuffer outQueueHead = null;
    ChannelBuffer outQueueTail = null;
    ChannelBuffer curOut = null;
    protected boolean bufferReady = false;
    protected boolean bgFlushScheduled = false;
    protected boolean closed = false;
    protected int unreportedError = 0;
    protected int refCount = 0;

    TclOutputStream(OutputStream inOutput) {
        this.output = inOutput;
    }

    void close() throws IOException {
        if (this.refCount > 0) {
            throw new TclRuntimeError("called Tcl_Close on channel with refCount > 0");
        }
        if (this.encoding != null && this.curOut != null) {
            this.encodingEnd = true;
            char[] empty = new char[]{};
            this.writeChars(empty, 0, 0);
        }
        if (this.curOut != null && this.curOut.nextAdded > this.curOut.nextRemoved) {
            this.bufferReady = true;
        }
        boolean result = false;
        this.closed = true;
        if (this.flushChannel(null, false) != 0 || result) {
            throw new IOException("Exception in flushChannel");
        }
    }

    protected int closeChannel(Interp interp, int errorCode) throws IOException {
        int result = 0;
        if (this.curOut != null) {
            this.curOut = null;
        }
        if (this.outQueueHead != null) {
            throw new TclRuntimeError("TclFlush, closed channel: queued output left");
        }
        if (this.eofChar != '\u0000') {
            try {
                this.output.write((byte)this.eofChar);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (this.unreportedError != 0) {
            errorCode = this.unreportedError;
        }
        if (errorCode != 0 || (errorCode = result) != 0) {
            // empty if block
        }
        return errorCode;
    }

    void flush() throws IOException {
        int result;
        if (this.curOut != null && this.curOut.nextAdded > this.curOut.nextRemoved) {
            this.bufferReady = true;
        }
        if ((result = this.flushChannel(null, false)) != 0) {
            throw new IOException("Exception during flushChannel");
        }
    }

    int flushChannel(Interp interp, boolean calledFromAsyncFlush) throws IOException {
        int errorCode = 0;
        boolean wroteSome = false;
        while (true) {
            int written;
            if (this.curOut != null && this.curOut.nextAdded == this.curOut.bufLength || this.bufferReady && this.outQueueHead == null) {
                this.bufferReady = false;
                this.curOut.next = null;
                if (this.outQueueHead == null) {
                    this.outQueueHead = this.curOut;
                } else {
                    this.outQueueTail.next = this.curOut;
                }
                this.outQueueTail = this.curOut;
                this.curOut = null;
            }
            ChannelBuffer buf = this.outQueueHead;
            if (!calledFromAsyncFlush && this.bgFlushScheduled) {
                return 0;
            }
            if (buf == null) break;
            int toWrite = buf.nextAdded - buf.nextRemoved;
            try {
                this.output.write(buf.buf, buf.nextRemoved, toWrite);
                written = toWrite;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                errorCode = 5;
                written = -1;
            }
            if (written < 0) {
                if (errorCode == 4) {
                    errorCode = 0;
                    continue;
                }
                if (errorCode == 35 || errorCode == 35) {
                    if (!this.bgFlushScheduled) {
                        this.bgFlushScheduled = true;
                        this.updateInterest();
                    }
                    errorCode = 0;
                    break;
                }
                if (calledFromAsyncFlush && this.unreportedError == 0) {
                    this.unreportedError = errorCode;
                }
                this.discardQueued();
                continue;
            }
            wroteSome = true;
            buf.nextRemoved += written;
            if (buf.nextRemoved != buf.nextAdded) continue;
            this.outQueueHead = buf.next;
            if (this.outQueueHead == null) {
                this.outQueueTail = null;
            }
            this.recycleBuffer(buf, false);
        }
        if (this.bgFlushScheduled) {
            if (wroteSome) {
                return errorCode;
            }
            if (this.outQueueHead == null) {
                this.bgFlushScheduled = false;
            }
        }
        if (this.closed && this.refCount <= 0 && this.outQueueHead == null && (this.curOut == null || this.curOut.nextAdded == this.curOut.nextRemoved)) {
            return this.closeChannel(interp, errorCode);
        }
        return errorCode;
    }

    void setEncoding(String inEncoding) {
        this.encoding = inEncoding;
    }

    void setEofChar(char inEofChar) {
        this.eofChar = inEofChar;
    }

    void setTranslation(int inTranslation) {
        this.translation = inTranslation;
    }

    void setBuffering(int inBuffering) {
        this.buffering = inBuffering;
    }

    void setBufferSize(int inBufSize) {
        this.bufSize = inBufSize;
        this.outputStage = null;
    }

    void setBlocking(boolean inBlocking) {
        this.blocking = inBlocking;
    }

    boolean isBlocked() {
        return this.blocked;
    }

    private void recycleBuffer(ChannelBuffer buf, boolean mustDiscard) {
        if (mustDiscard) {
            return;
        }
        if (buf.bufLength - 16 < this.bufSize) {
            return;
        }
        if (this.curOut == null) {
            this.curOut = buf;
            buf.nextRemoved = 16;
            buf.nextAdded = 16;
            buf.next = null;
        }
    }

    private void discardQueued() {
        while (this.outQueueHead != null) {
            ChannelBuffer buf = this.outQueueHead;
            this.outQueueHead = buf.next;
            this.recycleBuffer(buf, false);
        }
        this.outQueueHead = null;
        this.outQueueTail = null;
    }

    void updateInterest() {
    }

    int getNumBufferedBytes() {
        int IOQueued = 0;
        ChannelBuffer buf = this.outQueueHead;
        while (buf != null) {
            IOQueued += buf.nextAdded - buf.nextRemoved;
            buf = buf.next;
        }
        if (this.curOut != null && this.curOut.nextAdded > this.curOut.nextRemoved) {
            IOQueued += this.curOut.nextAdded - this.curOut.nextRemoved;
        }
        return IOQueued;
    }

    void seekCheckBuferReady() {
        if (this.curOut != null && this.curOut.nextAdded > this.curOut.nextRemoved) {
            this.bufferReady = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean translateEOL(Object dstArray, int dstStart, Object srcArray, int srcStart, IntPtr dstLenPtr, IntPtr srcLenPtr) {
        byte[] dstArrayByte;
        byte[] srcArrayByte;
        char[] dstArrayChar;
        char[] srcArrayChar;
        boolean isCharType;
        boolean debug = false;
        if (srcArray instanceof char[] && dstArray instanceof char[]) {
            isCharType = true;
            srcArrayChar = (char[])srcArray;
            dstArrayChar = (char[])dstArray;
            srcArrayByte = null;
            dstArrayByte = null;
        } else if (srcArray instanceof byte[] && dstArray instanceof byte[]) {
            isCharType = false;
            srcArrayChar = null;
            dstArrayChar = null;
            srcArrayByte = (byte[])srcArray;
            dstArrayByte = (byte[])dstArray;
        } else {
            throw new TclRuntimeError("unknown array argument types");
        }
        int src = srcStart;
        int dst = dstStart;
        boolean newlineFound = false;
        int srcLen = srcLenPtr.i;
        switch (this.translation) {
            case 2: {
                void var11_11;
                void var9_9;
                void var8_8;
                if (var8_8 != false) {
                    int dstEnd = dst + srcLen;
                    while (dst < dstEnd) {
                        if (var9_9[src] == 10) {
                            newlineFound = true;
                        }
                        var10_10[dst++] = var9_9[src++];
                    }
                } else {
                    int dstEnd = dst + srcLen;
                    while (dst < dstEnd) {
                        if (var11_11[src] == 10) {
                            newlineFound = true;
                        }
                        var12_12[dst++] = var11_11[src++];
                    }
                }
                dstLenPtr.i = srcLen;
                break;
            }
            case 3: {
                void var11_11;
                void var9_9;
                void var8_8;
                if (var8_8 != false) {
                    int dstEnd = dst + srcLen;
                    while (dst < dstEnd) {
                        if (var9_9[src] == 10) {
                            var10_10[dst++] = 13;
                            newlineFound = true;
                            ++src;
                            continue;
                        }
                        var10_10[dst++] = var9_9[src++];
                    }
                } else {
                    int dstEnd = dst + srcLen;
                    while (dst < dstEnd) {
                        if (var11_11[src] == 10) {
                            var12_12[dst++] = 13;
                            newlineFound = true;
                            ++src;
                            continue;
                        }
                        var12_12[dst++] = var11_11[src++];
                    }
                }
                dstLenPtr.i = srcLen;
                break;
            }
            case 4: {
                void var11_11;
                void var9_9;
                void var8_8;
                int dstMax = dst + dstLenPtr.i;
                int dstEnd = srcLen < dstLenPtr.i ? dst + srcLen : dst + dstLenPtr.i;
                if (var8_8 != false) {
                    while (dst < dstEnd) {
                        if (var9_9[src] == 10) {
                            if (dstEnd < dstMax) {
                                ++dstEnd;
                            }
                            var10_10[dst++] = 13;
                            newlineFound = true;
                        }
                        var10_10[dst++] = var9_9[src++];
                    }
                } else {
                    while (dst < dstEnd) {
                        if (var11_11[src] == 10) {
                            if (dstEnd < dstMax) {
                                ++dstEnd;
                            }
                            var12_12[dst++] = 13;
                            newlineFound = true;
                        }
                        var12_12[dst++] = var11_11[src++];
                    }
                }
                srcLenPtr.i = src - srcStart;
                dstLenPtr.i = dst - dstStart;
                break;
            }
        }
        return newlineFound;
    }

    int unicodeToExternal(char[] src, int srcOff, int srcLen, byte[] dst, int dstOff, int dstLen, IntPtr srcReadPtr, IntPtr dstWrotePtr, IntPtr dstCharsPtr) {
        int bytes_written;
        int chars_read;
        boolean debug = false;
        if (this.encoding == null) {
            throw new TclRuntimeError("unicodeToExternal called with null encoding");
        }
        if (srcLen == 0) {
            srcReadPtr.i = 0;
            if (dstWrotePtr != null) {
                dstWrotePtr.i = 0;
            }
            if (dstCharsPtr != null) {
                dstCharsPtr.i = 0;
            }
            return 0;
        }
        if (this.ctb == null) {
            try {
                this.ctb = CharToByteConverter.getConverter((String)this.encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new TclRuntimeError("unsupported encoding \"" + this.encoding + "\"");
            }
        }
        try {
            this.ctb.convertAny(src, srcOff, srcOff + srcLen, dst, dstOff, dstOff + dstLen);
            chars_read = this.ctb.nextCharIndex() - srcOff;
            int byte_index = this.ctb.nextByteIndex();
            bytes_written = byte_index - dstOff;
            int bytes_flushed = this.ctb.flushAny(dst, byte_index, dstOff + dstLen);
            if (bytes_flushed != 0) {
                System.out.println("bytes flushed is " + bytes_flushed);
                bytes_written += bytes_flushed;
            }
            if (chars_read == 0 && bytes_written == 0) {
                throw new TclRuntimeError("No characters converted");
            }
        }
        catch (ConversionBufferFullException ex) {
            chars_read = this.ctb.nextCharIndex() - srcOff;
            bytes_written = this.ctb.nextByteIndex() - dstOff;
        }
        srcReadPtr.i = chars_read;
        if (dstWrotePtr != null) {
            dstWrotePtr.i = bytes_written;
        }
        if (dstCharsPtr != null) {
            dstCharsPtr.i = chars_read;
        }
        int result = 0;
        return result;
    }

    int writeBytes(byte[] srcArray, int srcOff, int srcLen) throws IOException {
        IntPtr dstLen = new IntPtr();
        IntPtr toWrite = new IntPtr();
        int total = 0;
        int sawLF = 0;
        int savedLF = 0;
        int src = srcOff;
        while (srcLen + savedLF > 0) {
            int dstMax;
            ChannelBuffer buf = this.curOut;
            if (buf == null) {
                this.curOut = buf = new ChannelBuffer(this.bufSize);
            }
            byte[] dstArray = buf.buf;
            int dst = buf.nextAdded;
            toWrite.i = dstLen.i = (dstMax = buf.bufLength - buf.nextAdded);
            if (toWrite.i > srcLen) {
                toWrite.i = srcLen;
            }
            if (savedLF != 0) {
                dstArray[dst++] = 10;
                --dstLen.i;
                ++sawLF;
            }
            if (this.translateEOL(dstArray, dst, srcArray, src, dstLen, toWrite)) {
                ++sawLF;
            }
            dstLen.i += savedLF;
            savedLF = 0;
            if (dstLen.i > dstMax) {
                savedLF = 1;
                dstLen.i = dstMax;
            }
            buf.nextAdded += dstLen.i;
            if (this.checkFlush(buf, sawLF != 0) != 0) {
                return -1;
            }
            total += dstLen.i;
            src += toWrite.i;
            srcLen -= toWrite.i;
            sawLF = 0;
        }
        return total;
    }

    int checkFlush(ChannelBuffer buf, boolean newlineFlag) throws IOException {
        if (!this.bufferReady) {
            if (buf.nextAdded == buf.bufLength) {
                this.bufferReady = true;
            } else if (this.buffering == 1) {
                if (newlineFlag) {
                    this.bufferReady = true;
                }
            } else if (this.buffering == 2) {
                this.bufferReady = true;
            }
        }
        if (this.bufferReady && this.flushChannel(null, false) != 0) {
            return -1;
        }
        return 0;
    }

    int writeChars(char[] srcArray, int srcOff, int srcLen) throws IOException {
        byte[] safe = new byte[16];
        IntPtr stageLen = new IntPtr();
        IntPtr toWrite = new IntPtr();
        IntPtr stageRead = new IntPtr();
        IntPtr dstWrote = new IntPtr();
        int total = 0;
        int sawLF = 0;
        int savedLF = 0;
        int saved = 0;
        int src = 0;
        int endEncoding = this.encodingEnd ? 0 : 1;
        boolean consumedSomething = true;
        while (consumedSomething && srcLen + savedLF + endEncoding > 0) {
            int stageMax;
            consumedSomething = false;
            if (this.outputStage == null) {
                this.outputStage = new char[this.bufSize + 2];
            }
            char[] stageArray = this.outputStage;
            int stage = 0;
            toWrite.i = stageLen.i = (stageMax = this.bufSize);
            if (toWrite.i > srcLen) {
                toWrite.i = srcLen;
            }
            if (savedLF != 0) {
                stageArray[stage++] = 10;
                --stageLen.i;
                ++sawLF;
            }
            if (this.translateEOL(stageArray, stage, srcArray, src, stageLen, toWrite)) {
                ++sawLF;
            }
            stage -= savedLF;
            stageLen.i += savedLF;
            savedLF = 0;
            if (stageLen.i > stageMax) {
                savedLF = 1;
                stageLen.i = stageMax;
            }
            src += toWrite.i;
            srcLen -= toWrite.i;
            while (stageLen.i + saved + endEncoding > 0) {
                ChannelBuffer buf = this.curOut;
                if (buf == null) {
                    this.curOut = buf = new ChannelBuffer(this.bufSize);
                }
                byte[] dstArray = buf.buf;
                int dst = buf.nextAdded;
                int dstLen = buf.bufLength - buf.nextAdded;
                if (saved != 0) {
                    System.arraycopy(safe, 0, dstArray, dst, saved);
                    buf.nextAdded += saved;
                    dst += saved;
                    dstLen -= saved;
                    saved = 0;
                }
                int result = this.unicodeToExternal(stageArray, stage, stageLen.i, dstArray, dst, dstLen + 16, stageRead, dstWrote, null);
                this.encodingStart = false;
                buf.nextAdded += dstWrote.i;
                if (buf.nextAdded > buf.bufLength) {
                    saved = buf.nextAdded - buf.bufLength;
                    System.arraycopy(dstArray, dst + dstLen, safe, 0, saved);
                    buf.nextAdded = buf.bufLength;
                }
                if (this.checkFlush(buf, sawLF != 0) != 0) {
                    return -1;
                }
                total += dstWrote.i;
                stage += stageRead.i;
                stageLen.i -= stageRead.i;
                sawLF = 0;
                consumedSomething = true;
                if (stageLen.i + saved != 0 || result != 0) continue;
                endEncoding = 0;
            }
        }
        if (!consumedSomething && total == 0) {
            return -1;
        }
        return total;
    }

    int doWriteChars(char[] src, int srcOff, int srcLen) {
        return -1;
    }

    int writeObj(TclObject obj) throws IOException {
        if (this.encoding == null) {
            int srcLen = TclByteArray.getLength(null, obj);
            byte[] bytes = TclByteArray.getBytes(null, obj);
            return this.writeBytes(bytes, 0, srcLen);
        }
        String data = obj.toString();
        int num_chars = data.length();
        char[] chars = new char[num_chars];
        data.getChars(0, num_chars, chars, 0);
        return this.writeChars(chars, 0, num_chars);
    }

    private class IntPtr {
        int i;

        IntPtr() {
        }

        IntPtr(int value) {
            this.i = value;
        }
    }
}

