/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import blue.settings.UtilityOptionsPanelController;
import blue.settings.UtilitySettings;
import blue.ui.utilities.FileChooserManager;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class UtilityPanel
extends JPanel {
    public static final String CSOUND_EXECUTABLE = "csoundExecutable";
    public static final String FREEZE_FLAGS = "freezeFlags";
    private final UtilityOptionsPanelController controller;
    private boolean loading = false;
    private JTextField csoundExecText;
    private JTextField freezeFlagsText;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;

    UtilityPanel(UtilityOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        SimpleDocumentListener changeListener = new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!UtilityPanel.this.loading) {
                    UtilityPanel.this.controller.changed();
                }
            }
        };
        this.csoundExecText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.freezeFlagsText.getDocument().addDocumentListener((DocumentListener)changeListener);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.csoundExecText = new JTextField();
        this.jButton1 = new JButton();
        this.freezeFlagsText = new JTextField();
        this.jLabel1.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(UtilityPanel.class, (String)"UtilityPanel.jLabel1.text_1"));
        this.jLabel2.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(UtilityPanel.class, (String)"UtilityPanel.jLabel2.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(UtilityPanel.class, (String)"UtilityPanel.jButton1.text_1"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UtilityPanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, 96, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.csoundExecText, -1, 142, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.freezeFlagsText, -1, 226, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jLabel1, this.jLabel2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.csoundExecText, -2, -1, -2).addComponent(this.jButton1).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.freezeFlagsText, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(153, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        List retVal = FileChooserManager.getDefault().showOpenDialog(this.getClass(), (Component)this);
        if (!retVal.isEmpty()) {
            File f = (File)retVal.get(0);
            try {
                String path = f.getCanonicalPath();
                if (f.exists() && f.isFile()) {
                    this.csoundExecText.setText(path);
                    if (!this.loading) {
                        this.controller.changed();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getDefaultFreezeFlags() {
        String osName = System.getProperty("os.name");
        String flag = "W";
        if (osName.contains("Mac")) {
            flag = "A";
        }
        return "-" + flag + "do";
    }

    void load() {
        this.loading = true;
        UtilitySettings settings = UtilitySettings.getInstance();
        this.csoundExecText.setText(settings.csoundExecutable);
        this.freezeFlagsText.setText(settings.freezeFlags);
        this.loading = false;
    }

    void store() {
        UtilitySettings settings = UtilitySettings.getInstance();
        settings.csoundExecutable = this.csoundExecText.getText();
        settings.freezeFlags = this.freezeFlagsText.getText();
        settings.save();
    }

    boolean valid() {
        return true;
    }
}

