/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class UtilitySettings {
    public static final String PREFIX = "utility.";
    public static final String CSOUND_EXECUTABLE = "csoundExecutable";
    public static final String FREEZE_FLAGS = "freezeFlags";
    public String csoundExecutable = null;
    public String freezeFlags = null;
    private static UtilitySettings instance = null;

    private UtilitySettings() {
    }

    public static UtilitySettings getInstance() {
        if (instance == null) {
            instance = new UtilitySettings();
            String osName = System.getProperty("os.name");
            String flag = "W";
            String defaultCsoundCommand = "csound";
            if (osName.contains("Mac")) {
                flag = "A";
                defaultCsoundCommand = "/usr/local/bin/csound";
            }
            String defaultFreezeFlags = "-" + flag + "do";
            Preferences prefs = NbPreferences.forModule(UtilitySettings.class);
            UtilitySettings.instance.csoundExecutable = prefs.get("utility.csoundExecutable", defaultCsoundCommand);
            UtilitySettings.instance.freezeFlags = prefs.get("utility.freezeFlags", defaultFreezeFlags);
        }
        return instance;
    }

    public void save() {
        Preferences prefs = NbPreferences.forModule(UtilitySettings.class);
        prefs.put("utility.csoundExecutable", this.csoundExecutable);
        prefs.put("utility.freezeFlags", this.freezeFlags);
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

