/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import electric.util.Strings;
import electric.util.log.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;

public final class Streams {
    static final String ENCODING = "encoding=";
    static final int CHUNK_SIZE = 10000;
    static final byte[] NO_BYTES;

    public static void saveFile(String string, String string2, String string3, String string4) throws IOException {
        File file;
        if (!string.equals("")) {
            file = new File(string);
            file.mkdirs();
        }
        file = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(string2).append(string4))));
        System.out.println("write file ".concat(String.valueOf(String.valueOf(file))));
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(string3.getBytes());
        fileOutputStream.close();
    }

    public static byte[] loadResource(String string) throws IOException {
        URL uRL = new URL(string);
        InputStream inputStream = uRL.openStream();
        byte[] byArray = Streams.readFully(inputStream);
        inputStream.close();
        return byArray;
    }

    public static Reader getReader(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = Streams.readUpTo(fileInputStream, 100);
        fileInputStream.close();
        String string = Strings.normalizeEncoding(Streams.getEncoding(byArray));
        return new InputStreamReader((InputStream)new FileInputStream(file), string);
    }

    public static Reader getReader(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(100);
        byte[] byArray = Streams.readUpTo(inputStream, 100);
        inputStream.reset();
        String string = Strings.normalizeEncoding(Streams.getEncoding(byArray));
        return new InputStreamReader(inputStream, string);
    }

    public static String getEncoding(byte[] byArray) {
        if (Strings.isUTF16(byArray)) {
            return "UTF-16";
        }
        String string = new String(byArray);
        int n = string.indexOf(ENCODING);
        if (n == -1) {
            return null;
        }
        int n2 = n + ENCODING.length() + 1;
        char c = string.charAt(n2 - 1);
        int n3 = string.indexOf(c, n2);
        return string.substring(n2, n3);
    }

    public static Writer getWriter(File file, String string) throws UnsupportedEncodingException, IOException {
        return Streams.getWriter(new FileOutputStream(file), string);
    }

    public static Writer getWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        string = Strings.normalizeEncoding(string);
        return new OutputStreamWriter(outputStream, string);
    }

    public static URL getURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/".concat(String.valueOf(String.valueOf(string)));
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = String.valueOf(String.valueOf(string)).concat("/");
        }
        return new URL("file", "", string);
    }

    public static File[] listFiles(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(file.getPath(), stringArray[i]);
        }
        return fileArray;
    }

    public static byte[] readFully(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(byArray);
        randomAccessFile.close();
        return byArray;
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException(String.valueOf(String.valueOf(new StringBuffer("expected ").append(n2).append(" bytes of content, got ").append(i))));
        }
    }

    public static byte[] readFully(InputStream inputStream, int n) throws IOException {
        if (n <= 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n];
        Streams.readFully(inputStream, byArray, 0, n);
        return byArray;
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[10000];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int readUpTo(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n + n3, n2 - n3)) >= 0; n3 += n4) {
        }
        return n3;
    }

    public static byte[] readUpTo(InputStream inputStream, int n) throws IOException {
        if (n <= 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n];
        int n2 = Streams.readUpTo(inputStream, byArray, 0, n);
        if (n2 < n) {
            byte[] byArray2 = byArray;
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
        }
        return byArray;
    }

    public static String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n;
        while ((n = inputStream.read()) != -1) {
            if (n == 13) {
                n = inputStream.read();
                if (n == 10) {
                    return stringBuffer.toString();
                }
                stringBuffer.append('\r');
                stringBuffer.append((char)n);
                continue;
            }
            if (n == 10) {
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n, int n2, long l) throws IOException {
        int n3;
        int n4;
        byte[] byArray = new byte[n == -1 ? n2 : Math.min(n2, n)];
        int n5 = 0;
        while ((n4 = Streams.readUpTo(inputStream, byArray, 0, n3 = n == -1 ? n2 : Math.min(n2, n - n5))) != 0) {
            if (l > (long)-1 && Log.isLogging((long)l)) {
                Log.log((long)l, (Object)new String(byArray, 0, n4));
            }
            outputStream.write(byArray, 0, n4);
            if (n == -1 || (n5 += n4) < n) continue;
            break;
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n, int n2) throws IOException {
        Streams.copy(inputStream, outputStream, n, n2, -1L);
    }

    static {
        ENCODING = ENCODING;
        CHUNK_SIZE = 10000;
        NO_BYTES = new byte[0];
    }
}

