/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class IconFactory {
    private static Icon rightArrowIcon = null;
    private static Icon leftArrowIcon = null;
    private static Icon downArrowIcon = null;

    public static Icon getRightArrowIcon() {
        if (rightArrowIcon == null) {
            rightArrowIcon = new RightArrowIcon();
        }
        return rightArrowIcon;
    }

    public static Icon getLeftArrowIcon() {
        if (leftArrowIcon == null) {
            leftArrowIcon = new LeftArrowIcon();
        }
        return leftArrowIcon;
    }

    public static Icon getDownArrowIcon() {
        if (downArrowIcon == null) {
            downArrowIcon = new DownArrowIcon();
        }
        return downArrowIcon;
    }

    private static class DownArrowIcon
    implements Icon {
        private DownArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(c.getForeground());
            g.drawLine(0, 0, 7, 0);
            g.drawLine(1, 1, 6, 1);
            g.drawLine(2, 2, 5, 2);
            g.drawLine(3, 3, 4, 3);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 4;
        }
    }

    private static class LeftArrowIcon
    implements Icon {
        private LeftArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(c.getForeground());
            g.drawLine(3, 0, 3, 7);
            g.drawLine(2, 1, 2, 6);
            g.drawLine(1, 2, 1, 5);
            g.drawLine(0, 3, 0, 4);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 4;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }
    }

    private static class RightArrowIcon
    implements Icon {
        private RightArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(c.getForeground());
            g.drawLine(0, 0, 0, 7);
            g.drawLine(1, 1, 1, 6);
            g.drawLine(2, 2, 2, 5);
            g.drawLine(3, 3, 3, 4);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 4;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }
    }
}

