/*
 * Decompiled with CFR 0.152.
 */
package blue.jfx.binding;

import blue.jfx.BlueFX;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javafx.beans.property.FloatProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.TextField;

public class FloatBinder<T> {
    AtomicBoolean committing = new AtomicBoolean(false);
    private final WeakReference<TextField> textField;
    private WeakReference<FloatProperty> floatProperty = null;
    private BiFunction<T, Float, Float> filter;
    ChangeListener<? super Number> cl;
    private WeakReference<T> bean = null;

    public FloatBinder(TextField tf) {
        this(tf, null);
    }

    public FloatBinder(TextField tf, BiFunction<T, Float, Float> filter) {
        this.textField = new WeakReference<TextField>(tf);
        this.filter = filter;
        tf.focusedProperty().addListener((obs, o, n) -> {
            if (o.booleanValue() && !n.booleanValue()) {
                BlueFX.runOnFXThread(() -> this.updateValueFromTextFieldOrReset());
            }
        });
        tf.setOnAction(evt -> BlueFX.runOnFXThread(() -> this.updateValueFromTextFieldOrReset()));
        this.cl = (obs, oldVal, newVal) -> {
            TextField text = (TextField)this.textField.get();
            if (text != null) {
                BlueFX.runOnFXThread(() -> text.setText(newVal.toString()));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValueFromTextFieldOrReset() {
        TextField tf;
        FloatProperty fp;
        if (this.floatProperty == null || (fp = (FloatProperty)this.floatProperty.get()) == null || (tf = (TextField)this.textField.get()) == null) {
            return;
        }
        boolean inCommit = this.committing.getAndSet(true);
        try {
            if (!inCommit) {
                Float f = Float.valueOf(Float.parseFloat(tf.getText()));
                if (this.filter != null) {
                    f = this.filter.apply(this.bean.get(), f);
                }
                if (f != null) {
                    fp.setValue((Number)f);
                } else {
                    tf.setText(fp.getValue().toString());
                }
            }
        }
        catch (Exception e) {
            tf.setText(fp.getValue().toString());
        }
        finally {
            this.committing.set(false);
        }
    }

    public void setFloatProperty(T bean, FloatProperty prop) {
        FloatProperty fp = this.floatProperty == null ? null : (FloatProperty)this.floatProperty.get();
        TextField tf = (TextField)this.textField.get();
        if (tf == null) {
            return;
        }
        if (fp != null) {
            fp.removeListener(this.cl);
        }
        this.floatProperty = null;
        BlueFX.runOnFXThread(() -> tf.setText(prop.getValue().toString()));
        this.floatProperty = new WeakReference<FloatProperty>(prop);
        prop.addListener(this.cl);
        this.bean = new WeakReference<T>(bean);
    }
}

