/*
 * Decompiled with CFR 0.152.
 */
package blue.jfx.controls;

import blue.jfx.BlueFX;
import java.util.function.Predicate;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;

public class ValuePanel
extends TextField {
    StringProperty value = new SimpleStringProperty(""){

        protected void fireValueChangedEvent() {
            BlueFX.runOnFXThread(() -> super.fireValueChangedEvent());
        }
    };
    Predicate<String> validator = null;

    public ValuePanel() {
        this.getStyleClass().add((Object)"value-panel");
        this.setEditable(false);
        this.setOnMouseClicked(e -> {
            if (!this.isEditable() && e.getClickCount() >= 2) {
                this.setEditable(true);
                this.textProperty().unbind();
                this.setText(this.value.getValue());
                this.requestFocus();
                this.selectAll();
            }
        });
        this.setOnAction(e -> this.updateTextFromTextField());
        this.focusedProperty().addListener((obs, o, n) -> {
            if (o.booleanValue() && !n.booleanValue()) {
                this.textProperty().unbind();
                this.setText((String)this.value.get());
                this.setEditable(false);
                this.textProperty().bind((ObservableValue)this.value);
            }
        });
        this.textProperty().bind((ObservableValue)this.value);
    }

    private void updateTextFromTextField() {
        String newValue = this.getText();
        this.textProperty().unbind();
        if (this.validator == null || this.validator.test(newValue)) {
            this.value.setValue(newValue);
        }
        this.setEditable(false);
        this.textProperty().bind((ObservableValue)this.value);
    }

    public void setValidator(Predicate<String> validator) {
        this.validator = validator;
    }

    public void setValue(String value) {
        this.value.set((Object)(value == null ? "" : value));
    }

    public String getValue() {
        return (String)this.value.get();
    }

    public StringProperty valueProperty() {
        return this.value;
    }
}

