/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.BlueData;
import blue.ExceptionHandler;
import blue.GlobalVariables;
import blue.InstrumentLibrary;
import blue.library.Library;
import blue.soundObject.SoundObject;
import blue.udo.UDOLibrary;
import blue.utility.EnvironmentVars;
import blue.utility.FileUtilities;
import blue.utility.ObjectUtilities;
import electric.xml.Document;
import electric.xml.ParseException;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class BlueSystem {
    private static String programRootDir;
    private static String userConfigurationDirectory;
    private static ResourceBundle systemMessages;
    private static File currentProjectDirectory;
    private static InstrumentLibrary userInstrumentLibrary;
    private static UDOLibrary udoLibrary;
    private static Library<SoundObject> soundObjectLibrary;
    private static BlueData blueData;
    private static int menuShortcutKey;

    private static void init() {
        System.out.println("[blue] - initialization");
        BlueSystem.initializeProgramRootDir();
        System.out.println("\nprogram root directory: " + programRootDir);
        BlueSystem.setUserConfigurationDirectory();
        BlueSystem.setLocale();
        System.out.println("\n> loading classes from registry");
    }

    public static void setLocale() {
        Locale currentLocale = new Locale("en", "");
        try {
            systemMessages = ResourceBundle.getBundle("blue.resources.locale.SystemMessages", currentLocale);
        }
        catch (MissingResourceException mre) {
            System.out.println(mre.getLocalizedMessage());
            System.exit(1);
        }
    }

    private static void initializeProgramRootDir() {
        programRootDir = System.getProperty("BLUE_HOME");
        if (programRootDir == null) {
            programRootDir = System.getProperty("user.dir");
        }
    }

    public static String getString(String key) {
        String retVal = null;
        try {
            retVal = systemMessages.getString(key);
        }
        catch (MissingResourceException mre) {
            System.err.println("SystemMessages: Could not find key: " + key);
        }
        return retVal;
    }

    public static void setMenuText(JMenuItem item, String keyBase) {
        item.setText(systemMessages.getString(keyBase + ".text"));
        try {
            item.setMnemonic(systemMessages.getString(keyBase + ".mnemonic").charAt(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getShortClassName(String fullClassName) {
        int i = fullClassName.lastIndexOf(46);
        return fullClassName.substring(i + 1);
    }

    public static String getProgramRootDir() {
        return programRootDir;
    }

    public static String getUserScriptDir() {
        return BlueSystem.getUserConfigurationDirectory() + File.separator + "script";
    }

    public static String getConfDir() {
        return programRootDir + File.separator + "conf";
    }

    public static String getLibDir() {
        return programRootDir + File.separator + "lib";
    }

    public static String getUserConfigurationDirectory() {
        return userConfigurationDirectory;
    }

    public static Image getImage(String imageName) {
        Image retVal = Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("blue/resources/images/" + imageName));
        return retVal;
    }

    private static void setUserConfigurationDirectory() {
        File confFile;
        File legacyConfFile;
        boolean wasNotThere;
        boolean existed;
        userConfigurationDirectory = GlobalVariables.get(GlobalVariables.USER_CONFIG_DIR);
        if (userConfigurationDirectory == null) {
            userConfigurationDirectory = System.getProperty("user.home") + File.separator + ".blue";
            GlobalVariables.set(GlobalVariables.USER_CONFIG_DIR, userConfigurationDirectory);
        }
        if (!(existed = FileUtilities.ensureDirectoryExists(userConfigurationDirectory))) {
            System.out.println("Creating user configuration directory: " + userConfigurationDirectory);
            String userPythonLib = userConfigurationDirectory + File.separator + "pythonLib";
            FileUtilities.ensureDirectoryExists(userPythonLib);
            System.out.println("Creating user python lib in: " + userPythonLib);
            BlueSystem.getCodeRepository();
        }
        if (wasNotThere = FileUtilities.copyIfNotThere(legacyConfFile = new File(System.getProperty("user.home") + File.separator + ".blueConfig.xml"), confFile = new File(userConfigurationDirectory + File.separator + ".blueConfig.xml"))) {
            System.out.println("Copying legacy configuration file to user configuration directory");
        }
        System.out.println("user configuration directory: " + userConfigurationDirectory);
    }

    public static File getCodeRepository() {
        File repository = new File(BlueSystem.getUserConfigurationDirectory() + File.separator + "codeRepository.xml");
        if (!repository.exists()) {
            System.out.println("Copying default code repository to user configuration directory");
            try {
                Document doc = new Document(BlueSystem.class.getResourceAsStream("codeRepository.xml"));
                doc.write(repository);
            }
            catch (ParseException | IOException ex) {
                ExceptionHandler.printStackTrace((Exception)ex);
            }
        }
        return repository;
    }

    public static File getCurrentProjectDirectory() {
        return currentProjectDirectory;
    }

    public static void setCurrentProjectDirectory(File _currentProjectDirectory) {
        currentProjectDirectory = _currentProjectDirectory;
    }

    public static InstrumentLibrary getUserInstrumentLibrary() {
        if (userInstrumentLibrary == null) {
            String userInstrFileName = BlueSystem.getUserConfigurationDirectory() + File.separator + "userInstrumentLibrary.xml";
            File f = new File(userInstrFileName);
            if (f.exists()) {
                boolean error = false;
                try {
                    Document doc = new Document(f);
                    userInstrumentLibrary = InstrumentLibrary.loadFromXML(doc.getRoot());
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                    error = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error = true;
                }
                if (error) {
                    JOptionPane.showMessageDialog(null, "There was an error loading " + f.getAbsolutePath() + "\nPlease fix this file or remove it and restart blue.", "Error", 0);
                    System.exit(0);
                }
            } else {
                userInstrumentLibrary = new InstrumentLibrary();
            }
        }
        return userInstrumentLibrary;
    }

    public static void saveUserInstrumentLibrary() {
        String userInstrFileName = BlueSystem.getUserConfigurationDirectory() + File.separator + "userInstrumentLibrary.xml";
        String tmpFileName = userInstrFileName + ".tmp";
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(tmpFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out == null) {
            System.err.println("Unable to Save User Instrument Library: " + userInstrFileName);
            return;
        }
        String lib = userInstrumentLibrary.saveAsXML().toString();
        out.print(lib);
        out.flush();
        out.close();
        System.out.println("Saved User Instrument Library: " + userInstrFileName);
        File f = new File(userInstrFileName);
        if (f.exists()) {
            File backup = new File(userInstrFileName + "~");
            if (backup.exists()) {
                backup.delete();
            }
            f.renameTo(backup);
        }
        f = new File(tmpFileName);
        f.renameTo(new File(userInstrFileName));
    }

    public static UDOLibrary getUDOLibrary() {
        if (udoLibrary == null) {
            String userInstrFileName = BlueSystem.getUserConfigurationDirectory() + File.separator + "udoLibrary.xml";
            File f = new File(userInstrFileName);
            if (f.exists()) {
                boolean error = false;
                try {
                    Document doc = new Document(f);
                    udoLibrary = UDOLibrary.loadFromXML(doc.getRoot());
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                    error = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error = true;
                }
                if (error) {
                    JOptionPane.showMessageDialog(null, "There was an error loading " + f.getAbsolutePath() + "\nPlease fix this file or remove it and restart blue.", "Error", 0);
                    System.exit(0);
                }
            } else {
                udoLibrary = new UDOLibrary();
            }
        }
        return udoLibrary;
    }

    public static void saveUDOLibrary() {
        if (udoLibrary == null) {
            return;
        }
        String userInstrFileName = BlueSystem.getUserConfigurationDirectory() + File.separator + "udoLibrary.xml";
        String tmpFileName = userInstrFileName + ".tmp";
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(tmpFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out == null) {
            System.err.println("Unable to Save UDO Library: " + userInstrFileName);
            return;
        }
        String lib = udoLibrary.saveAsXML().toString();
        out.print(lib);
        out.flush();
        out.close();
        System.out.println("Saved UDO Library: " + userInstrFileName);
        File f = new File(userInstrFileName);
        if (f.exists()) {
            File backup = new File(userInstrFileName + "~");
            if (backup.exists()) {
                backup.delete();
            }
            f.renameTo(backup);
        }
        f = new File(tmpFileName);
        f.renameTo(new File(userInstrFileName));
    }

    public static Library<SoundObject> getSoundObjectLibrary() {
        if (soundObjectLibrary == null) {
            String userInstrFileName = BlueSystem.getUserConfigurationDirectory() + File.separator + "soundObjectLibrary.xml";
            File f = new File(userInstrFileName);
            if (f.exists()) {
                boolean error = false;
                try {
                    Document doc = new Document(f);
                    HashMap objRefMap = new HashMap();
                    soundObjectLibrary = Library.loadLibrary(doc.getRoot(), elem -> {
                        try {
                            return (SoundObject)ObjectUtilities.loadFromXML(elem, objRefMap);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    });
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                    error = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error = true;
                }
                if (error) {
                    JOptionPane.showMessageDialog(null, "There was an error loading " + f.getAbsolutePath() + "\nPlease fix this file or remove it and restart blue.", "Error", 0);
                    System.exit(0);
                }
            } else {
                soundObjectLibrary = Library.createLibrary("SoundObjects");
            }
        }
        return soundObjectLibrary;
    }

    public static void saveSoundObjectLibrary() {
        if (soundObjectLibrary == null) {
            return;
        }
        String userSObjFileName = BlueSystem.getUserConfigurationDirectory() + File.separator + "soundObjectLibrary.xml";
        String tmpFileName = userSObjFileName + ".tmp";
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(tmpFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out == null) {
            System.err.println("Unable to Save SoundObject Library: " + userSObjFileName);
            return;
        }
        HashMap dummyRefMap = new HashMap();
        String lib = soundObjectLibrary.saveAsXML(sObj -> sObj.getValue().saveAsXML(dummyRefMap)).toString();
        out.print(lib);
        out.flush();
        out.close();
        System.out.println("Saved SoundObject Library: " + userSObjFileName);
        File f = new File(userSObjFileName);
        if (f.exists()) {
            File backup = new File(userSObjFileName + "~");
            if (backup.exists()) {
                backup.delete();
            }
            f.renameTo(backup);
        }
        f = new File(tmpFileName);
        f.renameTo(new File(userSObjFileName));
    }

    public static void main(String[] args) {
        System.out.println(BlueSystem.getConfDir());
    }

    public static void setCurrentBlueData(BlueData _data) {
        blueData = _data;
    }

    public static BlueData getCurrentBlueData() {
        return blueData;
    }

    public static String getRelativePath(String path) {
        File projectDir = BlueSystem.getCurrentProjectDirectory();
        if (projectDir == null) {
            return path;
        }
        String projectPath = null;
        try {
            projectPath = projectDir.getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
        if (path.startsWith(projectPath)) {
            return path.substring(projectPath.length() + 1);
        }
        return path;
    }

    public static String getFullPath(String path) {
        File f = new File(path);
        if (f.isFile() && f.exists()) {
            return path;
        }
        File projectDir = BlueSystem.getCurrentProjectDirectory();
        if (projectDir == null) {
            return path;
        }
        String projectPath = null;
        try {
            projectPath = projectDir.getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
        f = new File(projectPath + File.separator + path);
        if (f.isFile() && f.exists()) {
            return f.getAbsolutePath();
        }
        return path;
    }

    public static File findFile(String path) {
        String sfDir;
        File f;
        if (path == null) {
            return null;
        }
        File projectDir = BlueSystem.getCurrentProjectDirectory();
        if (projectDir != null) {
            File f2;
            String projectPath = null;
            try {
                projectPath = projectDir.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (projectPath != null && (f2 = new File(projectPath + File.separator + path)).exists() && f2.isFile()) {
                return f2;
            }
        }
        if ((f = new File(path)).exists() && f.isFile()) {
            return f;
        }
        if (!path.contains(File.separator) && (sfDir = EnvironmentVars.getProperty("SFDIR")) != null && (f = new File(sfDir + File.separator + path)).exists() && f.isFile()) {
            return f;
        }
        return null;
    }

    public static ClassLoader getClassLoader() {
        return BlueSystem.class.getClassLoader();
    }

    public static synchronized int getMenuShortcutKey() {
        if (menuShortcutKey == -1) {
            menuShortcutKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        return menuShortcutKey;
    }

    static {
        userInstrumentLibrary = null;
        udoLibrary = null;
        soundObjectLibrary = null;
        blueData = null;
        menuShortcutKey = -1;
        BlueSystem.init();
    }
}

