/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.blueLive.LiveObject;
import blue.blueLive.LiveObjectBins;
import blue.blueLive.LiveObjectSetList;
import blue.soundObject.SoundObject;
import blue.utility.ObjectUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.Map;

public class LiveData {
    private String commandLine = "csound -Wdo devaudio -L stdin";
    private int tempo = 60;
    private int repeat = 4;
    private LiveObjectBins liveObjectBins;
    private LiveObjectSetList liveObjectSets;
    private boolean commandLineEnabled = false;
    private boolean commandLineOverride = false;
    private boolean repeatEnabled = false;

    public LiveData() {
        this.liveObjectBins = new LiveObjectBins();
        this.liveObjectSets = new LiveObjectSetList();
    }

    public LiveData(LiveData liveData) {
        this.commandLine = liveData.commandLine;
        this.tempo = liveData.tempo;
        this.repeat = liveData.repeat;
        this.commandLineEnabled = liveData.commandLineEnabled;
        this.commandLineOverride = liveData.commandLineOverride;
        this.repeatEnabled = liveData.repeatEnabled;
        this.liveObjectBins = new LiveObjectBins(liveData.liveObjectBins);
        this.liveObjectSets = new LiveObjectSetList(liveData.liveObjectSets);
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String string) {
        this.commandLine = string;
    }

    public LiveObjectBins getLiveObjectBins() {
        return this.liveObjectBins;
    }

    public LiveObjectSetList getLiveObjectSets() {
        return this.liveObjectSets;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public int getTempo() {
        return this.tempo;
    }

    public void setTempo(int tempo) {
        this.tempo = tempo;
    }

    public static LiveData loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        LiveData liveData = new LiveData();
        Elements nodes = data.getElements();
        boolean doCommandLineUpgrade = true;
        ArrayList<LiveObject> oldFormat = new ArrayList<LiveObject>();
        Element liveObjectSetsNode = null;
        while (nodes.hasMoreElements()) {
            String name;
            Element node = nodes.next();
            switch (name = node.getName()) {
                case "commandLine": {
                    liveData.setCommandLine(node.getTextString());
                    break;
                }
                case "commandLineEnabled": {
                    liveData.setCommandLineEnabled(XMLUtilities.readBoolean(node));
                    doCommandLineUpgrade = false;
                    break;
                }
                case "commandLineOverride": {
                    liveData.setCommandLineOverride(XMLUtilities.readBoolean(node));
                    doCommandLineUpgrade = false;
                    break;
                }
                case "soundObject": {
                    SoundObject sObj = (SoundObject)ObjectUtilities.loadFromXML(node, objRefMap);
                    LiveObject lObj = new LiveObject();
                    lObj.setSObj(sObj);
                    oldFormat.add(lObj);
                    break;
                }
                case "liveObject": {
                    oldFormat.add(LiveObject.loadFromXML(node, objRefMap));
                    break;
                }
                case "liveObjectBins": {
                    liveData.liveObjectBins = LiveObjectBins.loadFromXML(node, objRefMap);
                    break;
                }
                case "repeat": {
                    liveData.repeat = XMLUtilities.readInt(node);
                    break;
                }
                case "tempo": {
                    liveData.tempo = XMLUtilities.readInt(node);
                    break;
                }
                case "liveObjectSetList": {
                    liveObjectSetsNode = node;
                    break;
                }
                case "repeatEnabled": {
                    liveData.setRepeatEnabled(XMLUtilities.readBoolean(node));
                }
            }
        }
        if (oldFormat.size() > 0) {
            LiveObject[][] liveObjectBins = new LiveObject[1][oldFormat.size()];
            for (int i = 0; i < oldFormat.size(); ++i) {
                liveObjectBins[0][i] = (LiveObject)oldFormat.get(i);
            }
            liveData.liveObjectBins = new LiveObjectBins(liveObjectBins);
        }
        if (doCommandLineUpgrade) {
            liveData.setCommandLineEnabled(true);
            liveData.setCommandLineOverride(true);
        }
        if (liveObjectSetsNode != null) {
            liveData.liveObjectSets = LiveObjectSetList.loadFromXML(liveObjectSetsNode, liveData.liveObjectBins);
        }
        return liveData;
    }

    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = new Element("liveData");
        retVal.addElement("commandLine").setText(this.commandLine);
        retVal.addElement(XMLUtilities.writeBoolean("commandLineEnabled", this.commandLineEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("commandLineOverride", this.commandLineOverride));
        retVal.addElement(this.liveObjectBins.saveAsXML(objRefMap));
        retVal.addElement(this.liveObjectSets.saveAsXML());
        retVal.addElement(XMLUtilities.writeInt("repeat", this.repeat));
        retVal.addElement(XMLUtilities.writeInt("tempo", this.tempo));
        retVal.addElement(XMLUtilities.writeBoolean("repeatEnabled", this.repeatEnabled));
        return retVal;
    }

    public boolean isCommandLineEnabled() {
        return this.commandLineEnabled;
    }

    public void setCommandLineEnabled(boolean commandLineEnabled) {
        this.commandLineEnabled = commandLineEnabled;
    }

    public boolean isCommandLineOverride() {
        return this.commandLineOverride;
    }

    public void setCommandLineOverride(boolean commandLineOverride) {
        this.commandLineOverride = commandLineOverride;
    }

    public boolean isRepeatEnabled() {
        return this.repeatEnabled;
    }

    public void setRepeatEnabled(boolean repeatEnabled) {
        this.repeatEnabled = repeatEnabled;
    }
}

