/*
 * Decompiled with CFR 0.152.
 */
package blue.blueLive;

import blue.blueLive.LiveObject;
import blue.blueLive.LiveObjectSet;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;

public class LiveObjectBins {
    private LiveObject[][] liveObjectBins;
    transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public LiveObjectBins() {
        this(new LiveObject[1][8]);
    }

    public LiveObjectBins(LiveObject[][] liveObjectBins) {
        this.liveObjectBins = liveObjectBins;
    }

    public LiveObjectBins(LiveObjectBins bins) {
        this.liveObjectBins = (LiveObject[][])bins.liveObjectBins.clone();
        for (int i = 0; i < this.liveObjectBins.length; ++i) {
            for (int j = 0; j < this.liveObjectBins[i].length; ++j) {
                if (bins.liveObjectBins[i][j] == null) continue;
                this.liveObjectBins[i][j] = new LiveObject(bins.liveObjectBins[i][j]);
            }
        }
    }

    public static LiveObjectBins loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        if (data.getAttributeValue("columns") == null) {
            throw new Exception("LiveObjectBins could not load");
        }
        int columns = Integer.parseInt(data.getAttributeValue("columns"));
        int rows = Integer.parseInt(data.getAttributeValue("rows"));
        LiveObjectBins retVal = new LiveObjectBins(new LiveObject[columns][rows]);
        Elements nodes = data.getElements();
        int column = 0;
        while (nodes.hasMoreElements()) {
            int row = 0;
            Element node = nodes.next();
            String name = node.getName();
            if (!name.equals("bin")) continue;
            Elements lObjNodes = node.getElements();
            while (lObjNodes.hasMoreElements()) {
                Element lObjNode = lObjNodes.next();
                name = lObjNode.getName();
                if (name.equals("liveObject")) {
                    retVal.liveObjectBins[column][row] = LiveObject.loadFromXML(lObjNode, objRefMap);
                }
                ++row;
            }
            ++column;
        }
        return retVal;
    }

    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = new Element("liveObjectBins");
        retVal.setAttribute("columns", Integer.toString(this.liveObjectBins.length));
        retVal.setAttribute("rows", Integer.toString(this.liveObjectBins[0].length));
        for (int i = 0; i < this.liveObjectBins.length; ++i) {
            Element bin = retVal.addElement("bin");
            for (int j = 0; j < this.liveObjectBins[i].length; ++j) {
                LiveObject lObj = this.liveObjectBins[i][j];
                if (lObj == null) {
                    bin.addElement("null");
                    continue;
                }
                bin.addElement(lObj.saveAsXML(objRefMap));
            }
        }
        return retVal;
    }

    public void setLiveObject(int column, int row, LiveObject liveObject) {
        LiveObject oldObject = this.liveObjectBins[column][row];
        this.liveObjectBins[column][row] = liveObject;
        this.listeners.firePropertyChange("liveObject", oldObject, liveObject);
    }

    public void insertRow(int index) {
        LiveObject[][] newBins = new LiveObject[this.liveObjectBins.length][this.liveObjectBins[0].length + 1];
        if (index < 0) {
            index = 0;
        } else if (index > this.liveObjectBins[0].length) {
            index = this.liveObjectBins[0].length;
        }
        for (int i = 0; i < newBins.length; ++i) {
            int readCounter = 0;
            for (int j = 0; j < newBins[i].length; ++j) {
                if (j == index) continue;
                newBins[i][j] = this.liveObjectBins[i][readCounter];
                ++readCounter;
            }
        }
        int oldCount = this.liveObjectBins[0].length;
        this.liveObjectBins = newBins;
        this.listeners.firePropertyChange("rowCount", oldCount, newBins[0].length);
    }

    public void removeRow(int index) {
        if (index < 0 || index >= this.liveObjectBins[0].length || this.liveObjectBins[0].length <= 1) {
            return;
        }
        LiveObject[][] newBins = new LiveObject[this.liveObjectBins.length][this.liveObjectBins[0].length - 1];
        for (int i = 0; i < this.liveObjectBins.length; ++i) {
            int writeCounter = 0;
            for (int j = 0; j < this.liveObjectBins[i].length; ++j) {
                if (j == index) continue;
                newBins[i][writeCounter] = this.liveObjectBins[i][j];
                ++writeCounter;
            }
        }
        int oldCount = this.liveObjectBins[0].length;
        this.liveObjectBins = newBins;
        this.listeners.firePropertyChange("rowCount", oldCount, newBins[0].length);
    }

    public void insertColumn(int index) {
        LiveObject[][] newBins = new LiveObject[this.liveObjectBins.length + 1][this.liveObjectBins[0].length];
        if (index < 0) {
            index = 0;
        } else if (index > this.liveObjectBins.length) {
            index = this.liveObjectBins.length;
        }
        int readCounter = 0;
        boolean inserted = false;
        for (int i = 0; i < newBins.length; ++i) {
            if (!inserted && readCounter == index) {
                inserted = true;
                continue;
            }
            System.arraycopy(this.liveObjectBins[readCounter], 0, newBins[i], 0, this.liveObjectBins[0].length);
            ++readCounter;
        }
        int oldCount = this.liveObjectBins.length;
        this.liveObjectBins = newBins;
        this.listeners.firePropertyChange("columnCount", oldCount, newBins.length);
    }

    public void removeColumn(int index) {
        if (index < 0 || index >= this.liveObjectBins.length || this.liveObjectBins.length <= 1) {
            return;
        }
        LiveObject[][] newBins = new LiveObject[this.liveObjectBins.length - 1][this.liveObjectBins[0].length];
        int writeCounter = 0;
        boolean inserted = false;
        for (int i = 0; i < this.liveObjectBins.length; ++i) {
            if (i == index) continue;
            System.arraycopy(this.liveObjectBins[i], 0, newBins[writeCounter], 0, this.liveObjectBins[0].length);
            ++writeCounter;
        }
        int oldCount = this.liveObjectBins.length;
        this.liveObjectBins = newBins;
        this.listeners.firePropertyChange("columnCount", oldCount, newBins.length);
    }

    public int getColumnCount() {
        return this.liveObjectBins.length;
    }

    public int getRowCount() {
        return this.liveObjectBins[0].length;
    }

    public LiveObject getLiveObject(int column, int row) {
        return this.liveObjectBins[column][row];
    }

    public int getColumnForObject(LiveObject liveObject) {
        if (liveObject == null) {
            return -1;
        }
        for (int i = 0; i < this.liveObjectBins.length; ++i) {
            for (int j = 0; j < this.liveObjectBins[i].length; ++j) {
                if (this.liveObjectBins[i][j] != liveObject) continue;
                return i;
            }
        }
        return -1;
    }

    public int getRowForObject(LiveObject liveObject) {
        if (liveObject == null) {
            return -1;
        }
        for (int i = 0; i < this.liveObjectBins.length; ++i) {
            for (int j = 0; j < this.liveObjectBins[i].length; ++j) {
                if (this.liveObjectBins[i][j] != liveObject) continue;
                return j;
            }
        }
        return -1;
    }

    public void addPropertyChangeListener(PropertyChangeListener cl) {
        this.listeners.addPropertyChangeListener(cl);
    }

    public void removePropertyChangeListener(PropertyChangeListener cl) {
        this.listeners.removePropertyChangeListener(cl);
    }

    public LiveObjectSet getEnabledLiveObjectSet() {
        LiveObjectSet retVal = new LiveObjectSet();
        for (int i = 0; i < this.liveObjectBins.length; ++i) {
            for (int j = 0; j < this.liveObjectBins[0].length; ++j) {
                LiveObject lObj = this.liveObjectBins[i][j];
                if (lObj == null || !lObj.isEnabled()) continue;
                retVal.add(lObj);
            }
        }
        return retVal;
    }

    public void setEnabledFromLiveObjectSet(LiveObjectSet liveObjectSet) {
        for (int i = 0; i < this.liveObjectBins.length; ++i) {
            for (int j = 0; j < this.liveObjectBins[0].length; ++j) {
                LiveObject lObj = this.liveObjectBins[i][j];
                if (lObj != null && liveObjectSet.contains(lObj)) {
                    lObj.setEnabled(true);
                    continue;
                }
                lObj.setEnabled(false);
            }
        }
        this.listeners.firePropertyChange("enabledStateChanged", false, false);
    }

    public LiveObject getLiveObjectByUniqueId(String uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        for (int i = 0; i < this.liveObjectBins.length; ++i) {
            for (int j = 0; j < this.liveObjectBins[0].length; ++j) {
                LiveObject lObj = this.liveObjectBins[i][j];
                if (lObj == null || !uniqueId.equals(lObj.getUniqueId())) continue;
                return lObj;
            }
        }
        return null;
    }
}

