/*
 * Decompiled with CFR 0.152.
 */
package blue.components.lines;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class LineUtils {
    public static double rescale(double oldVal, double oldMin, double oldMax, double newMin, double newMax, BigDecimal resolution) {
        double oldRange = oldMax - oldMin;
        double percent = (oldVal - oldMin) / oldRange;
        double newRange = newMax - newMin;
        double newVal = percent * newRange + newMin;
        if (resolution.doubleValue() > 0.0) {
            newVal = LineUtils.snapToResolution(newVal, newMin, newMax, resolution);
        }
        return newVal;
    }

    public static double truncate(double oldVal, double newMin, double newMax) {
        return Math.max(newMin, Math.min(newMax, oldVal));
    }

    public static double snapToResolution(double value, double min, double max, BigDecimal resolution) {
        if (value >= max) {
            return max;
        }
        if (value <= min) {
            return min;
        }
        if (resolution.doubleValue() <= 0.0) {
            return value;
        }
        double retVal = value - min;
        if (resolution.doubleValue() > 0.0) {
            BigDecimal v = new BigDecimal(retVal).setScale(resolution.scale(), RoundingMode.HALF_UP);
            v = v.subtract(v.remainder(resolution));
            retVal = v.doubleValue();
        }
        return retVal + min;
    }
}

