/*
 * Decompiled with CFR 0.152.
 */
package blue.library;

import blue.library.LibraryItem;
import blue.library.LibraryTreeItem;
import blue.soundObject.SoundObject;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javafx.scene.control.TreeItem;

public class Library<T extends SoundObject> {
    TreeItem<LibraryItem<T>> root;
    static final Set<String> FOLDER_NAMES = new HashSet<String>();

    public static <T extends SoundObject> Library<T> createLibrary(String rootName) {
        Library<T> lib = new Library<T>();
        lib.root = new LibraryTreeItem<LibraryItem<LibraryItem<T>>>(new LibraryItem(rootName));
        return lib;
    }

    public static <T extends SoundObject> Library<T> loadLibrary(Element elem, Function<Element, T> loader) {
        Library<T> lib = new Library<T>();
        lib.root = Library.loadLibraryItem(elem.getElement("category"), loader);
        return lib;
    }

    private static <T extends SoundObject> TreeItem<LibraryItem<T>> loadLibraryItem(Element elem, Function<Element, T> loader) {
        LibraryTreeItem<LibraryItem<Object>> item;
        if (FOLDER_NAMES.contains(elem.getName())) {
            item = new LibraryTreeItem(new LibraryItem(elem.getAttributeValue("categoryName")));
            Elements children = elem.getElements();
            while (children.hasMoreElements()) {
                item.getChildren().add(Library.loadLibraryItem(children.next(), loader));
            }
        } else {
            item = new LibraryTreeItem<LibraryItem<SoundObject>>(new LibraryItem<SoundObject>((SoundObject)loader.apply(elem)));
        }
        return item;
    }

    public Element saveAsXML(Function<LibraryItem<T>, Element> saver) {
        Element retVal = new Element("soundObjectLibrary");
        retVal.addElement(this.saveAsXML(this.root, saver));
        return retVal;
    }

    private Element saveAsXML(TreeItem<LibraryItem<T>> item, Function<LibraryItem<T>, Element> saver) {
        Element retVal;
        LibraryItem libItem = (LibraryItem)item.getValue();
        if (libItem.getValue() == null) {
            retVal = new Element("category");
            retVal.setAttribute("categoryName", libItem.displayName);
            for (TreeItem child : item.getChildren()) {
                retVal.addElement(this.saveAsXML(child, saver));
            }
        } else {
            retVal = saver.apply(libItem);
        }
        return retVal;
    }

    public TreeItem<LibraryItem<T>> getRoot() {
        return this.root;
    }

    static {
        FOLDER_NAMES.add("instrumentCategory");
        FOLDER_NAMES.add("effectCategory");
        FOLDER_NAMES.add("udoCategory");
        FOLDER_NAMES.add("category");
    }
}

