/*
 * Decompiled with CFR 0.152.
 */
package blue.mixer;

import blue.automation.Automatable;
import blue.automation.AutomatableCollectionListener;
import blue.mixer.Effect;
import blue.mixer.Send;
import blue.utility.ListUtil;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class EffectsChain
implements ListModel,
PropertyChangeListener {
    private ArrayList effects = new ArrayList();
    private transient List<ListDataListener> listeners = null;
    private transient List<AutomatableCollectionListener> automatableCollectionListeners = null;

    public EffectsChain() {
    }

    public EffectsChain(EffectsChain chain) {
        for (Object item : chain.effects) {
            if (item instanceof Effect) {
                this.addEffect(new Effect((Effect)item));
                continue;
            }
            if (!(item instanceof Send)) continue;
            this.addSend(new Send((Send)item));
        }
    }

    public Element saveAsXML() {
        Element retVal = new Element("effectsChain");
        for (Object obj : this.effects) {
            if (obj instanceof Effect) {
                Effect elem = (Effect)obj;
                retVal.addElement(elem.saveAsXML());
                continue;
            }
            if (!(obj instanceof Send)) continue;
            Send send = (Send)obj;
            retVal.addElement(send.saveAsXML());
        }
        return retVal;
    }

    public static EffectsChain loadFromXML(Element data) throws Exception {
        EffectsChain chain = new EffectsChain();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "effect": {
                    chain.addEffect(Effect.loadFromXML(node));
                    break;
                }
                case "send": {
                    chain.addSend(Send.loadFromXML(node));
                }
            }
        }
        return chain;
    }

    public void addEffect(Effect effect) {
        this.effects.add(effect);
        int val = this.effects.indexOf(effect);
        ListDataEvent lde = new ListDataEvent(this, 1, val, val);
        this.fireAddDataEvent(lde);
        this.fireAutomatableAdded(effect);
    }

    public void addSend(Send send) {
        this.effects.add(send);
        int val = this.effects.indexOf(send);
        ListDataEvent lde = new ListDataEvent(this, 1, val, val);
        this.fireAddDataEvent(lde);
        this.fireAutomatableAdded(send);
        send.addPropertyChangeListener(this);
    }

    public Object removeElementAt(int index) {
        Object obj = this.effects.remove(index);
        if (obj instanceof Send) {
            ((Send)obj).removePropertyChangeListener(this);
        }
        ListDataEvent lde = new ListDataEvent(this, 2, index, index);
        this.fireRemoveDataEvent(lde);
        this.fireAutomatableRemoved((Automatable)obj);
        return obj;
    }

    public int size() {
        return this.effects.size();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public void pushUp(int index) {
        if (index > 0 && index < this.size()) {
            Object a = this.effects.remove(index - 1);
            this.effects.add(index, a);
            ListDataEvent lde = new ListDataEvent(this, 0, index - 1, index);
            this.fireContentsChangedEvent(lde);
        }
    }

    public void pushDown(int index) {
        if (index < this.size() - 1) {
            Object a = this.effects.remove(index + 1);
            this.effects.add(index, a);
            ListDataEvent lde = new ListDataEvent(this, 0, index - 1, index);
            this.fireContentsChangedEvent(lde);
        }
    }

    public Send[] getSends() {
        ArrayList<Send> temp = new ArrayList<Send>();
        for (int i = 0; i < this.size(); ++i) {
            Object obj = this.getElementAt(i);
            if (!(obj instanceof Send)) continue;
            temp.add((Send)obj);
        }
        Send[] sends = new Send[temp.size()];
        sends = temp.toArray(sends);
        return sends;
    }

    @Override
    public int getSize() {
        return this.effects.size();
    }

    public Object getElementAt(int index) {
        return this.effects.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector<ListDataListener>();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    private void fireAddDataEvent(ListDataEvent lde) {
        if (this.listeners == null) {
            return;
        }
        for (ListDataListener listener : this.listeners) {
            listener.intervalAdded(lde);
        }
    }

    private void fireRemoveDataEvent(ListDataEvent lde) {
        if (this.listeners == null) {
            return;
        }
        for (ListDataListener listener : this.listeners) {
            listener.intervalRemoved(lde);
        }
    }

    private void fireContentsChangedEvent(ListDataEvent lde) {
        if (this.listeners == null) {
            return;
        }
        for (ListDataListener listener : this.listeners) {
            listener.contentsChanged(lde);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void addAutomatableCollectionListener(AutomatableCollectionListener listener) {
        if (this.automatableCollectionListeners == null) {
            this.automatableCollectionListeners = new Vector<AutomatableCollectionListener>();
        }
        this.automatableCollectionListeners.add(listener);
    }

    public void removeAutomatableCollectionListener(AutomatableCollectionListener listener) {
        if (this.automatableCollectionListeners != null) {
            this.automatableCollectionListeners.remove(listener);
        }
    }

    private void fireAutomatableAdded(Automatable automatable) {
        if (this.automatableCollectionListeners != null) {
            for (AutomatableCollectionListener listener : this.automatableCollectionListeners) {
                listener.automatableAdded(automatable);
            }
        }
    }

    private void fireAutomatableRemoved(Automatable automatable) {
        if (this.automatableCollectionListeners != null) {
            for (AutomatableCollectionListener listener : this.automatableCollectionListeners) {
                listener.automatableRemoved(automatable);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object obj;
        int index;
        if (evt.getPropertyName().equals("sendChannel") && (index = ListUtil.indexOfByRef(this.effects, obj = evt.getSource())) >= 0) {
            ListDataEvent lde = new ListDataEvent(this, 0, index, index);
            this.fireContentsChangedEvent(lde);
        }
    }
}

