/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.utility.ScoreUtilities;
import electric.xml.Element;

public class PchAddProcessor
implements NoteProcessor {
    int value = 0;
    int pfield = 4;

    public PchAddProcessor() {
    }

    public PchAddProcessor(PchAddProcessor pap) {
        this.value = pap.value;
        this.pfield = pap.pfield;
    }

    public String toString() {
        return "[pch add]";
    }

    public String getPfield() {
        return Integer.toString(this.pfield);
    }

    public void setPfield(String pfield) {
        int p = Integer.parseInt(pfield);
        if (p > 3) {
            this.pfield = p;
        }
    }

    public String getVal() {
        return Integer.toString(this.value);
    }

    public void setVal(String value) {
        this.value = Integer.parseInt(value);
    }

    @Override
    public final void processNotes(NoteList in) throws NoteProcessorException {
        for (int i = 0; i < in.size(); ++i) {
            String val;
            Note temp = (Note)in.get(i);
            try {
                val = temp.getPField(this.pfield).trim();
                Double.parseDouble(val);
            }
            catch (NumberFormatException ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.pfieldNotDouble"), this.pfield);
            }
            catch (Exception ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield);
            }
            double baseTen = ScoreUtilities.getBaseTen(val);
            int octave = (int)((baseTen += (double)this.value) / 12.0);
            double strPch = baseTen % 12.0 / 100.0;
            temp.setPField(Double.toString((double)octave + strPch), this.pfield);
        }
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i + " 2 6.0" + i + " 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        PchAddProcessor pchAdd1 = new PchAddProcessor();
        pchAdd1.setPfield("4");
        pchAdd1.setVal("-4");
        try {
            pchAdd1.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public static NoteProcessor loadFromXML(Element data) {
        PchAddProcessor pap = new PchAddProcessor();
        pap.setPfield(data.getElement("pfield").getTextString());
        pap.setVal(data.getElement("value").getTextString());
        return pap;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield").setText(this.getPfield());
        retVal.addElement("value").setText(this.getVal());
        return retVal;
    }

    @Override
    public PchAddProcessor deepCopy() {
        return new PchAddProcessor(this);
    }
}

