/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.automation.Parameter;
import blue.automation.ParameterList;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.ClampedValue;
import blue.orchestra.blueSynthBuilder.ClampedValueListener;
import blue.utility.XMLUtilities;
import electric.xml.Element;

public abstract class AutomatableBSBObject
extends BSBObject {
    boolean automationAllowed = true;
    transient ParameterList parameters = null;

    public AutomatableBSBObject() {
    }

    public AutomatableBSBObject(AutomatableBSBObject bsbObj) {
        super(bsbObj);
        this.automationAllowed = bsbObj.isAutomationAllowed();
    }

    public void setParameterList(ParameterList parameters) {
        this.parameters = parameters;
        this.initializeParameters();
    }

    @Override
    public void setObjectName(String objectName) {
        if (objectName == null || objectName.equals(this.getObjectName())) {
            return;
        }
        if (this.unm != null && objectName != null && objectName.length() != 0 && !this.unm.isUnique(objectName)) {
            return;
        }
        String oldName = this.getObjectName();
        boolean doInitialize = false;
        if (this.parameters != null && this.automationAllowed) {
            if (objectName == null || objectName.length() == 0) {
                this.parameters.removeParameter(oldName);
            } else {
                Parameter param = this.parameters.getParameter(oldName);
                if (param == null) {
                    doInitialize = true;
                } else {
                    param.setName(objectName);
                }
            }
        }
        super.setObjectName(objectName);
        if (doInitialize) {
            this.initializeParameters();
        }
    }

    public static void initBasicFromXML(Element data, BSBObject bsbObj) {
        BSBObject.initBasicFromXML(data, bsbObj);
        Element elem = data.getElement("automationAllowed");
        AutomatableBSBObject automatableBsbObj = (AutomatableBSBObject)bsbObj;
        automatableBsbObj.automationAllowed = elem != null ? Boolean.valueOf(elem.getTextString()) : false;
    }

    public static Element getBasicXML(BSBObject bsbObj) {
        Element retVal = BSBObject.getBasicXML(bsbObj);
        retVal.addElement(XMLUtilities.writeBoolean("automationAllowed", ((AutomatableBSBObject)bsbObj).automationAllowed));
        return retVal;
    }

    protected abstract void initializeParameters();

    public boolean isAutomationAllowed() {
        return this.automationAllowed;
    }

    public abstract void setAutomationAllowed(boolean var1);

    protected void updateParameter(ClampedValue cv, Parameter param, ClampedValueListener.PropertyType pType, ClampedValueListener.BoundaryType bType) {
        switch (pType) {
            case MIN: {
                param.setMin(cv.getMin(), bType == ClampedValueListener.BoundaryType.TRUNCATE);
                break;
            }
            case MAX: {
                param.setMax(cv.getMax(), bType == ClampedValueListener.BoundaryType.TRUNCATE);
                break;
            }
            case VALUE: {
                if (param.isAutomationEnabled()) break;
                param.setValue(cv.getValue());
                break;
            }
            case RESOLUTION: {
                param.setResolution(cv.getResolution());
            }
        }
    }
}

