/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.StringChannel;
import blue.orchestra.blueSynthBuilder.StringChannelProvider;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BSBFileSelector
extends BSBObject
implements StringChannelProvider {
    StringProperty fileName;
    IntegerProperty textFieldWidth;
    BooleanProperty stringChannelEnabled;
    private StringChannel stringChannel;

    public BSBFileSelector() {
        this.fileName = new SimpleStringProperty("");
        this.textFieldWidth = new SimpleIntegerProperty(100);
        this.stringChannelEnabled = new SimpleBooleanProperty(true);
        this.fileName.addListener((obs, oldVal, newVal) -> this.fireStringChannelChange((String)oldVal, (String)newVal));
        this.stringChannel = new StringChannel();
        this.addPropertyChangeListener(this.stringChannel);
    }

    public BSBFileSelector(BSBFileSelector fs) {
        super(fs);
        this.fileName = new SimpleStringProperty(fs.getFileName());
        this.textFieldWidth = new SimpleIntegerProperty(fs.getTextFieldWidth());
        this.stringChannelEnabled = new SimpleBooleanProperty(fs.isStringChannelEnabled());
        this.fileName.addListener((obs, oldVal, newVal) -> this.fireStringChannelChange((String)oldVal, (String)newVal));
        this.stringChannel = new StringChannel(fs.getStringChannel());
        this.addPropertyChangeListener(this.stringChannel);
    }

    public void fireStringChannelChange(String oldFileName, String newFileName) {
        if (this.propListeners != null) {
            this.propListeners.firePropertyChange("stringChannelValue", oldFileName, newFileName);
        }
    }

    public final void setFileName(String value) {
        this.fileName.set((Object)value);
    }

    public final String getFileName() {
        return (String)this.fileName.get();
    }

    public final StringProperty fileNameProperty() {
        return this.fileName;
    }

    public final void setTextFieldWidth(int value) {
        this.textFieldWidth.set(value);
    }

    public final int getTextFieldWidth() {
        return this.textFieldWidth.get();
    }

    public final IntegerProperty textFieldWidthProperty() {
        return this.textFieldWidth;
    }

    public final void setStringChannelEnabled(boolean value) {
        this.stringChannelEnabled.set(value);
    }

    @Override
    public final boolean isStringChannelEnabled() {
        return this.stringChannelEnabled.get();
    }

    public final BooleanProperty stringChannelEnabledProperty() {
        return this.stringChannelEnabled;
    }

    public static BSBObject loadFromXML(Element data) {
        BSBFileSelector selector = new BSBFileSelector();
        BSBFileSelector.initBasicFromXML(data, selector);
        Elements nodes = data.getElements();
        boolean stringChannelEnabled = false;
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            switch (node.getName()) {
                case "fileName": {
                    selector.setFileName(node.getTextString());
                    break;
                }
                case "textFieldWidth": {
                    selector.setTextFieldWidth(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "stringChannelEnabled": {
                    stringChannelEnabled = XMLUtilities.readBoolean(node);
                }
            }
        }
        selector.setStringChannelEnabled(stringChannelEnabled);
        return selector;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBFileSelector.getBasicXML(this);
        retVal.addElement("fileName").setText(this.getFileName());
        retVal.addElement("textFieldWidth").setText(Integer.toString(this.getTextFieldWidth()));
        retVal.addElement(XMLUtilities.writeBoolean("stringChannelEnabled", this.isStringChannelEnabled()));
        return retVal;
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        String fileNameValue = this.getFileName().replace('\\', '/');
        if (this.isStringChannelEnabled()) {
            this.stringChannel.setValue(fileNameValue);
            this.stringChannel.setChannelName(this.stringChannel.getChannelName());
            compilationUnit.addReplacementValue(this.getObjectName(), this.stringChannel.getChannelName());
        } else {
            compilationUnit.addReplacementValue(this.getObjectName(), fileNameValue);
        }
    }

    @Override
    public String getPresetValue() {
        return this.getFileName();
    }

    @Override
    public void setPresetValue(String val) {
        this.setFileName(val);
    }

    @Override
    public StringChannel getStringChannel() {
        return this.stringChannel;
    }

    @Override
    public BSBObject deepCopy() {
        return new BSBFileSelector(this);
    }
}

