/*
 * Decompiled with CFR 0.152.
 */
package blue.scripting;

import blue.BlueSystem;
import blue.scripting.Script;
import blue.scripting.ScriptCategory;
import blue.utility.ListUtil;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ScriptLibrary
implements TreeModel {
    private static ScriptLibrary library = null;
    ScriptCategory rootScriptCategory = new ScriptCategory();
    transient Vector listeners = new Vector();
    transient Vector changeListeners = new Vector();

    private ScriptLibrary() {
        this.rootScriptCategory.setRoot(true);
        this.rootScriptCategory.setCategoryName("Script Library");
    }

    public static ScriptLibrary getInstance() {
        if (library == null) {
            String scriptLibFileName = BlueSystem.getUserConfigurationDirectory() + File.separator + "scriptLibrary.xml";
            File f = new File(scriptLibFileName);
            if (f.exists()) {
                boolean error = false;
                try {
                    Document doc = new Document(f);
                    library = ScriptLibrary.loadFromXML(doc.getRoot());
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                    error = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error = true;
                }
                if (error) {
                    JOptionPane.showMessageDialog(null, "There was an error loading " + f.getAbsolutePath() + "\nPlease fix this file or remove it and restart blue.", "Error", 0);
                    System.exit(0);
                }
            }
            if (library == null) {
                library = new ScriptLibrary();
                System.out.println("Creating new Script Library");
            }
        }
        return library;
    }

    public ScriptCategory getRootScriptCategory() {
        return this.rootScriptCategory;
    }

    public void setRootScriptCategory(ScriptCategory rootScriptCategory) {
        this.rootScriptCategory = rootScriptCategory;
    }

    public void addScript(ScriptCategory parent, Script script) {
        this.addScript(parent, -1, script);
    }

    public void addScript(ScriptCategory parent, int insertIndex, Script script) {
        if (insertIndex < 0 || insertIndex >= parent.getScripts().size()) {
            parent.addScript(script);
        } else {
            parent.addScript(insertIndex, script);
        }
        int index = this.getIndexOfChild(parent, script);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{script};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(script), childIndices, children);
        this.fireNodesInserted(e);
    }

    private Object[] getPathForObject(Object obj) {
        Vector v = new Vector();
        this.getPathForObject(this.getRootScriptCategory(), obj, v);
        Collections.reverse(v);
        return v.toArray();
    }

    private Object getPathForObject(ScriptCategory current, Object obj, Vector v) {
        if (current == obj) {
            return v;
        }
        if (current.getScripts().contains(obj)) {
            v.add(current);
            return v;
        }
        for (ScriptCategory cat : current.getSubCategories()) {
            Object pathObj = this.getPathForObject(cat, obj, v);
            if (pathObj == null) continue;
            v.add(current);
            return v;
        }
        return null;
    }

    public void addCategory(ScriptCategory parent, ScriptCategory cat) {
        parent.addScriptCategory(cat);
        int index = this.getIndexOfChild(parent, cat);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{cat};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(cat), childIndices, children);
        this.fireNodesInserted(e);
    }

    public void removeScript(Script script) {
        ScriptCategory parent = this.findParent(this.rootScriptCategory, script);
        int index = this.getIndexOfChild(parent, script);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{script};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(script), childIndices, children);
        this.rootScriptCategory.removeScript(script);
        this.fireNodesRemoved(e);
    }

    public void removeScriptCategory(ScriptCategory cat) {
        ScriptCategory parent = this.findParent(this.rootScriptCategory, cat);
        int index = this.getIndexOfChild(parent, cat);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{cat};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(cat), childIndices, children);
        this.rootScriptCategory.removeScriptCategory(cat);
        this.fireNodesRemoved(e);
    }

    public static ScriptLibrary loadFromXML(Element data) throws Exception {
        ScriptLibrary iLibrary = new ScriptLibrary();
        iLibrary.setRootScriptCategory(ScriptCategory.loadFromXML(data.getElement("scriptCategory")));
        return iLibrary;
    }

    public Element saveAsXML() {
        Element retVal = new Element("scriptLibrary");
        retVal.addElement(this.rootScriptCategory.saveAsXML());
        return retVal;
    }

    public void save() {
        String scriptLibFileName = BlueSystem.getUserConfigurationDirectory() + File.separator + "scriptLibrary.xml";
        PrintWriter out = null;
        File f = new File(scriptLibFileName);
        if (f.exists()) {
            File backup = new File(scriptLibFileName + "~");
            if (backup.exists()) {
                backup.delete();
            }
            f.renameTo(backup);
        }
        try {
            out = new PrintWriter(new FileWriter(scriptLibFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out != null) {
            String lib = this.saveAsXML().toString();
            out.print(lib);
            out.flush();
            out.close();
            System.out.println("Saved Script Library: " + scriptLibFileName);
        } else {
            System.err.println("Unable to Save Script Library: " + scriptLibFileName);
        }
        this.fireChangeEvent();
    }

    @Override
    public Object getRoot() {
        return this.getRootScriptCategory();
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof Script) {
            return 0;
        }
        if (parent instanceof ScriptCategory) {
            ScriptCategory cat = (ScriptCategory)parent;
            return cat.getSubCategories().size() + cat.getScripts().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof Script;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object obj = path.getLastPathComponent();
        if (obj instanceof ScriptCategory) {
            ((ScriptCategory)obj).setCategoryName(newValue.toString());
        } else if (obj instanceof Script) {
            ((Script)obj).setName(newValue.toString());
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        this.fireNodesChanged(e);
    }

    private void fireNodesChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesChanged(e);
        }
    }

    private void fireNodesInserted(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesInserted(e);
        }
    }

    private void fireNodesRemoved(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesRemoved(e);
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeStructureChanged(e);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        ScriptCategory category = (ScriptCategory)parent;
        if (category == null) {
            return null;
        }
        if (index >= category.getSubCategories().size()) {
            return category.getScripts().get(index - category.getSubCategories().size());
        }
        return category.getSubCategories().get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        ScriptCategory category = (ScriptCategory)parent;
        if (category == null || child == null) {
            return -1;
        }
        int retVal = ListUtil.indexOfByRef(category.getSubCategories(), child);
        if (retVal >= 0) {
            return retVal;
        }
        retVal = ListUtil.indexOfByRef(category.getScripts(), child);
        if (retVal >= 0) {
            return retVal + category.getSubCategories().size();
        }
        return -1;
    }

    private ScriptCategory findParent(ScriptCategory cat, Object obj) {
        if (ListUtil.containsByRef(cat.getScripts(), obj) || ListUtil.containsByRef(cat.getSubCategories(), obj)) {
            return cat;
        }
        for (ScriptCategory c : cat.getSubCategories()) {
            ScriptCategory temp = this.findParent(c, obj);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireChangeEvent() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(evt);
        }
    }

    public void importScript(Script script) {
        ArrayList categories = this.rootScriptCategory.getSubCategories();
        for (ScriptCategory cat : categories) {
            if (!cat.getCategoryName().equals("Imported Scripts")) continue;
            this.addScript(cat, script);
            this.save();
            return;
        }
        ScriptCategory cat = new ScriptCategory();
        cat.setCategoryName("Imported Scripts");
        cat.addScript(script);
        this.addCategory(this.rootScriptCategory, cat);
        this.save();
    }
}

