/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.BlueSystem;
import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.orchestra.GenericInstrument;
import blue.orchestra.Instrument;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.SoundFileUtilities;
import electric.xml.Element;
import java.io.IOException;
import java.util.Map;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;

public class AudioFile
extends AbstractSoundObject {
    private String soundFileName;
    private String csoundPostCode;
    private boolean useCustomWindowSize = false;
    private int windowSize = 8;

    public AudioFile() {
        this.setName("Audio File");
        this.soundFileName = "";
        this.csoundPostCode = "\touts\taChannel1, aChannel1";
    }

    public AudioFile(AudioFile af) {
        super(af);
        this.soundFileName = af.soundFileName;
        this.csoundPostCode = af.csoundPostCode;
        this.useCustomWindowSize = af.useCustomWindowSize;
        this.windowSize = af.windowSize;
    }

    public NoteList generateNotes(int instrumentNumber, double renderStart, double renderEnd) throws SoundObjectException {
        NoteList n = new NoteList();
        double newDur = this.subjectiveDuration;
        if (renderEnd > 0.0 && renderEnd < this.subjectiveDuration) {
            newDur = renderEnd;
        }
        newDur -= renderStart;
        StringBuilder buffer = new StringBuilder();
        buffer.append("i").append(instrumentNumber);
        buffer.append("\t").append(this.startTime + renderStart);
        buffer.append("\t").append(newDur);
        buffer.append("\t").append(renderStart);
        Note tempNote = null;
        try {
            tempNote = Note.createNote(buffer.toString());
        }
        catch (NoteParseException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        if (tempNote != null) {
            n.add(tempNote);
        }
        return n;
    }

    public Instrument generateInstrument() {
        String instrumentText = this.generateInstrumentText();
        if (instrumentText == null) {
            return null;
        }
        GenericInstrument temp = new GenericInstrument();
        temp.setName(this.name);
        temp.setText(instrumentText);
        return temp;
    }

    private String generateInstrumentText() {
        StringBuilder iText = new StringBuilder();
        String channelVariables = this.getChannelVariables();
        if (channelVariables == null) {
            return null;
        }
        String sfName = this.getSoundFileName().replace('\\', '/');
        iText.append(channelVariables).append("\tdiskin2\t\"");
        iText.append(sfName);
        iText.append("\", 1, p4\n");
        iText.append(this.getCsoundPostCode());
        return iText.toString();
    }

    private String getChannelVariables() {
        int numChannels;
        try {
            numChannels = SoundFileUtilities.getNumberOfChannels(this.getSoundFileName());
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, BlueSystem.getString("soundfile.infoPanel.error.couldNotOpenFile") + " " + this.getSoundFileName());
            return null;
        }
        catch (UnsupportedAudioFileException uae) {
            JOptionPane.showMessageDialog(null, BlueSystem.getString("soundfile.infoPanel.error.unsupportedAudio") + " " + uae.getLocalizedMessage());
            return null;
        }
        if (numChannels <= 0) {
            return null;
        }
        String info = "aChannel1";
        int i = 1;
        while (i < numChannels) {
            info = info + ", aChannel" + ++i;
        }
        return info;
    }

    public int findPowerOfTwo(double seconds) {
        int powTwoSamples;
        int sr = 44100;
        int samples = (int)Math.round(seconds * (double)sr);
        for (powTwoSamples = 2; powTwoSamples < samples; powTwoSamples *= 2) {
        }
        return powTwoSamples;
    }

    @Override
    public double getObjectiveDuration() {
        return this.subjectiveDuration;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return null;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain chain) {
    }

    @Override
    public int getTimeBehavior() {
        return -1;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
    }

    @Override
    public double getRepeatPoint() {
        return -1.0;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
    }

    public String getCsoundPostCode() {
        return this.csoundPostCode;
    }

    public void setCsoundPostCode(String string) {
        this.csoundPostCode = string;
    }

    public String getSoundFileName() {
        return this.soundFileName;
    }

    public void setSoundFileName(String string) {
        this.soundFileName = string;
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        AudioFile aFile = new AudioFile();
        SoundObjectUtilities.initBasicFromXML(data, aFile);
        String sFileName = data.getElement("soundFileName").getTextString();
        if (sFileName != null) {
            aFile.setSoundFileName(sFileName);
        }
        aFile.setCsoundPostCode(data.getElement("csoundPostCode").getTextString());
        return aFile;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement("soundFileName").setText(this.getSoundFileName());
        retVal.addElement("csoundPostCode").setText(this.getCsoundPostCode());
        return retVal;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        Instrument instr = this.generateInstrument();
        if (instr == null) {
            throw new RuntimeException(new SoundObjectException((SoundObject)this, BlueSystem.getString("audioFile.couldNotGenerate") + " " + this.getSoundFileName()));
        }
        int instrNum = compileData.addInstrument(instr);
        NoteList nl = this.generateNotes(instrNum, startTime, endTime);
        return nl;
    }

    @Override
    public AudioFile deepCopy() {
        return new AudioFile(this);
    }
}

