/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.jmask.Table;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Mask {
    private double high = 1.0;
    private double low = 0.0;
    private double mapValue = 0.0;
    private boolean highTableEnabled = false;
    private boolean lowTableEnabled = false;
    private Table highTable = new Table();
    private Table lowTable = new Table();
    private boolean enabled = false;
    private transient double duration = 1.0;

    public Mask() {
    }

    public Mask(Mask mask) {
        this.high = mask.high;
        this.low = mask.low;
        this.mapValue = mask.mapValue;
        this.highTableEnabled = mask.highTableEnabled;
        this.lowTableEnabled = mask.lowTableEnabled;
        this.highTable = new Table(mask.highTable);
        this.lowTable = new Table(mask.lowTable);
        this.enabled = mask.enabled;
    }

    public static Mask loadFromXML(Element data) {
        Mask retVal = new Mask();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            block9 : switch (nodeName = node.getName()) {
                case "table": {
                    String tabInstance;
                    Table t = Table.loadFromXML(node);
                    switch (tabInstance = node.getAttributeValue("tableId")) {
                        case "highTable": {
                            retVal.highTable = t;
                            break block9;
                        }
                        case "lowTable": {
                            retVal.lowTable = t;
                        }
                    }
                    break;
                }
                case "highTableEnabled": {
                    retVal.highTableEnabled = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "lowTableEnabled": {
                    retVal.lowTableEnabled = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "low": {
                    retVal.low = Double.parseDouble(node.getTextString());
                    break;
                }
                case "high": {
                    retVal.high = Double.parseDouble(node.getTextString());
                    break;
                }
                case "mapValue": {
                    retVal.mapValue = Double.parseDouble(node.getTextString());
                    break;
                }
                case "enabled": {
                    retVal.enabled = Boolean.valueOf(node.getTextString());
                }
            }
        }
        return retVal;
    }

    public Element saveAsXML() {
        Element retVal = new Element("mask");
        retVal.addElement(XMLUtilities.writeBoolean("highTableEnabled", this.highTableEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("lowTableEnabled", this.lowTableEnabled));
        retVal.addElement(XMLUtilities.writeDouble("low", this.low));
        retVal.addElement(XMLUtilities.writeDouble("high", this.high));
        retVal.addElement(XMLUtilities.writeDouble("mapValue", this.mapValue));
        retVal.addElement(XMLUtilities.writeBoolean("enabled", this.enabled));
        Element hTableNode = this.highTable.saveAsXML();
        hTableNode.setAttribute("tableId", "highTable");
        retVal.addElement(hTableNode);
        Element lTableNode = this.lowTable.saveAsXML();
        lTableNode.setAttribute("tableId", "lowTable");
        retVal.addElement(lTableNode);
        return retVal;
    }

    private double mapper(double x, double e) {
        if (e == 0.0) {
            return x;
        }
        return Math.pow(x, e);
    }

    public double getValue(double time, double val) {
        if (!this.enabled) {
            return val;
        }
        double localHigh = this.highTableEnabled ? this.highTable.getValue(time / this.duration) : this.high;
        double localLow = this.lowTableEnabled ? this.lowTable.getValue(time / this.duration) : this.low;
        double retVal = localLow + (localHigh - localLow) * this.mapper(val, this.mapValue);
        return retVal;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public double getHigh() {
        return this.high;
    }

    public void setHigh(double high) {
        this.high = high;
    }

    public double getLow() {
        return this.low;
    }

    public void setLow(double low) {
        this.low = low;
    }

    public double getMapValue() {
        return this.mapValue;
    }

    public void setMapValue(double mapValue) {
        this.mapValue = mapValue;
    }

    public boolean isHighTableEnabled() {
        return this.highTableEnabled;
    }

    public void setHighTableEnabled(boolean highTableEnabled) {
        this.highTableEnabled = highTableEnabled;
    }

    public boolean isLowTableEnabled() {
        return this.lowTableEnabled;
    }

    public void setLowTableEnabled(boolean lowTableEnabled) {
        this.lowTableEnabled = lowTableEnabled;
    }

    public Table getHighTable() {
        return this.highTable;
    }

    public void setHighTable(Table highTable) {
        this.highTable = highTable;
    }

    public Table getLowTable() {
        return this.lowTable;
    }

    public void setLowTable(Table lowTable) {
        this.lowTable = lowTable;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }
}

