/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask.probability;

import blue.soundObject.jmask.Table;
import blue.soundObject.jmask.probability.ProbabilityGenerator;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;

public class Gaussian
implements ProbabilityGenerator {
    private double sigma;
    private double mu;
    private boolean sigmaTableEnabled = false;
    private boolean muTableEnabled = false;
    private Table sigmaTable = new Table();
    private Table muTable = new Table();

    public Gaussian() {
        this.sigma = 0.1;
        this.mu = 0.5;
        this.sigmaTable = new Table();
        this.muTable = new Table();
        this.sigmaTable.getPoint(0).setValue(0.1);
        this.sigmaTable.getPoint(1).setValue(0.1);
        this.muTable.getPoint(0).setValue(0.5);
        this.muTable.getPoint(1).setValue(0.5);
    }

    public Gaussian(Gaussian gauss) {
        this.sigma = gauss.sigma;
        this.mu = gauss.mu;
        this.sigmaTableEnabled = gauss.sigmaTableEnabled;
        this.muTableEnabled = gauss.muTableEnabled;
        this.sigmaTable = new Table(gauss.sigmaTable);
        this.muTable = new Table(gauss.muTable);
    }

    public static ProbabilityGenerator loadFromXML(Element data) {
        Gaussian retVal = new Gaussian();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            block7 : switch (nodeName = node.getName()) {
                case "sigma": {
                    retVal.sigma = XMLUtilities.readDouble(node);
                    break;
                }
                case "mu": {
                    retVal.mu = XMLUtilities.readDouble(node);
                    break;
                }
                case "sigmaTableEnabled": {
                    retVal.sigmaTableEnabled = XMLUtilities.readBoolean(node);
                    break;
                }
                case "muTableEnabled": {
                    retVal.muTableEnabled = XMLUtilities.readBoolean(node);
                    break;
                }
                case "table": {
                    String tableId;
                    switch (tableId = node.getAttributeValue("tableId")) {
                        case "sigmaTable": {
                            retVal.sigmaTable = Table.loadFromXML(node);
                            break block7;
                        }
                        case "muTable": {
                            retVal.muTable = Table.loadFromXML(node);
                        }
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("probabilityGenerator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement(XMLUtilities.writeDouble("sigma", this.sigma));
        retVal.addElement(XMLUtilities.writeDouble("mu", this.mu));
        retVal.addElement(XMLUtilities.writeBoolean("sigmaTableEnabled", this.sigmaTableEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("muTableEnabled", this.muTableEnabled));
        Element sigmaTableNode = this.sigmaTable.saveAsXML();
        sigmaTableNode.setAttribute("tableId", "sigmaTable");
        Element muTableNode = this.muTable.saveAsXML();
        muTableNode.setAttribute("tableId", "muTable");
        retVal.addElement(sigmaTableNode);
        retVal.addElement(muTableNode);
        return retVal;
    }

    @Override
    public String getName() {
        return "Gaussian";
    }

    @Override
    public double getValue(double time, Random rnd) {
        double sum;
        double e;
        double localSigma = this.sigmaTableEnabled ? this.sigmaTable.getValue(time) : this.sigma;
        double localMu = this.muTableEnabled ? this.muTable.getValue(time) : this.mu;
        do {
            sum = 0.0;
            for (int i = 1; i <= 12; ++i) {
                sum += rnd.nextDouble();
            }
        } while ((e = localSigma * (sum - 6.0) + localMu) > 1.0 || e < 0.0);
        return e;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double mu) {
        this.mu = mu;
    }

    public boolean isSigmaTableEnabled() {
        return this.sigmaTableEnabled;
    }

    public void setSigmaTableEnabled(boolean sigmaTableEnabled) {
        this.sigmaTableEnabled = sigmaTableEnabled;
    }

    public boolean isMuTableEnabled() {
        return this.muTableEnabled;
    }

    public void setMuTableEnabled(boolean muTableEnabled) {
        this.muTableEnabled = muTableEnabled;
    }

    public Table getSigmaTable() {
        return this.sigmaTable;
    }

    public void setSigmaTable(Table sigmaTable) {
        this.sigmaTable = sigmaTable;
    }

    public Table getMuTable() {
        return this.muTable;
    }

    public void setMuTable(Table muTable) {
        this.muTable = muTable;
    }

    @Override
    public Gaussian deepCopy() {
        return new Gaussian(this);
    }
}

