/*
 * Decompiled with CFR 0.152.
 */
package blue.utility;

import blue.Arrangement;
import blue.BlueData;
import blue.BlueSystem;
import blue.SoundLayer;
import blue.orchestra.GenericInstrument;
import blue.score.layers.LayerGroup;
import blue.soundObject.GenericScore;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.PolyObject;
import blue.udo.OpcodeList;
import blue.udo.UserDefinedOpcode;
import blue.utility.ScoreSection;
import blue.utility.ScoreUtilities;
import blue.utility.TextUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class CSDUtility {
    public static final int IMPORT_GLOBAL = 0;
    public static final int IMPORT_SINGLE_SOUNDOBJECT = 1;
    public static final int IMPORT_SOUNDOBJECT_PER_INSTRUMENT = 2;

    public static BlueData convertOrcScoToBlue(File orcFile, File scoFile, int importMode) {
        BlueData data = null;
        try {
            String orc = TextUtilities.getTextFromFile(orcFile);
            String sco = TextUtilities.getTextFromFile(scoFile);
            data = new BlueData();
            CSDUtility.parseCsOrc(data, orc);
            CSDUtility.parseCsScore(data, sco, importMode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static BlueData convertCSDtoBlue(File csdFile, int importMode) {
        BlueData data = null;
        try {
            String CSD = TextUtilities.getTextFromFile(csdFile);
            data = CSDUtility.convertCSDtoBlue(CSD, importMode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    private static BlueData convertCSDtoBlue(String CSD, int importMode) {
        BlueData data = new BlueData();
        String orc = TextUtilities.getTextBetweenTags("CsInstruments", CSD);
        String sco = TextUtilities.getTextBetweenTags("CsScore", CSD);
        CSDUtility.parseCsOrc(data, orc);
        CSDUtility.parseCsScore(data, sco, importMode);
        return data;
    }

    protected static void parseCsScore(BlueData data, String scoreText, int importMode) {
        StringBuilder tables = new StringBuilder();
        StringBuilder iStatements = new StringBuilder();
        String[] lines = scoreText.split("\n");
        block5: for (int i = 0; i < lines.length; ++i) {
            char c;
            String nextLine;
            String line = lines[i].trim();
            if (line.startsWith("f")) {
                tables.append(lines[i]).append("\n");
                if (i >= lines.length - 1) continue;
                while ((nextLine = lines[i + 1].trim()).length() != 0 && (Character.isDigit(c = nextLine.charAt(0)) || c == '\"' || c == '.')) {
                    tables.append(lines[i + 1]).append("\n");
                    if (++i < lines.length - 1) continue;
                    continue block5;
                }
                continue;
            }
            if (line.startsWith("i")) {
                iStatements.append(line).append("\n");
                if (i >= lines.length - 1) continue;
                while ((nextLine = lines[i + 1].trim()).length() != 0 && (Character.isDigit(c = nextLine.charAt(0)) || c == '\"' || c == '.')) {
                    iStatements.append(lines[i + 1]).append("\n");
                    if (++i < lines.length - 1) continue;
                    continue block5;
                }
                continue;
            }
            if (!line.startsWith("s")) continue;
            iStatements.append(line).append("\n");
        }
        String noteText = iStatements.toString();
        switch (importMode) {
            case 0: {
                ((LayerGroup)data.getScore().get(0)).newLayerAt(-1);
                data.getGlobalOrcSco().setGlobalSco(noteText);
                break;
            }
            case 1: {
                int i;
                ScoreSection[] sections = CSDUtility.getScoreSections(noteText);
                for (i = 0; i < sections.length; ++i) {
                    CSDUtility.setSoundObjectPerSection(data, sections[i]);
                }
                break;
            }
            case 2: {
                int i;
                ScoreSection[] sections = CSDUtility.getScoreSections(noteText);
                for (i = 0; i < sections.length; ++i) {
                    CSDUtility.setSoundObjectsPerInstrument(data, sections[i]);
                }
                break;
            }
        }
        data.getTableSet().setTables(tables.toString());
    }

    private static ScoreSection[] getScoreSections(String scoreText) {
        ScoreSection section;
        ArrayList<ScoreSection> scoreSections = new ArrayList<ScoreSection>();
        StringTokenizer st = new StringTokenizer(scoreText, "\n");
        String line = "";
        StringBuffer currentSection = new StringBuffer();
        double sectionStartTime = 0.0;
        while (st.hasMoreTokens()) {
            line = st.nextToken().trim();
            if (line.startsWith("s")) {
                NoteList nl;
                section = new ScoreSection();
                section.scoreText = currentSection.toString();
                section.sectionStartTime = sectionStartTime;
                scoreSections.add(section);
                try {
                    nl = ScoreUtilities.getNotes(section.scoreText);
                }
                catch (NoteParseException e) {
                    throw new RuntimeException(e);
                }
                sectionStartTime += ScoreUtilities.getTotalDuration(nl);
                currentSection = new StringBuffer();
                continue;
            }
            currentSection.append(line).append("\n");
        }
        section = new ScoreSection();
        section.scoreText = currentSection.toString();
        section.sectionStartTime = sectionStartTime;
        scoreSections.add(section);
        ScoreSection[] returnSections = new ScoreSection[scoreSections.size()];
        for (int i = 0; i < scoreSections.size(); ++i) {
            returnSections[i] = (ScoreSection)scoreSections.get(i);
        }
        return returnSections;
    }

    private static void setSoundObjectPerSection(BlueData data, ScoreSection section) {
        GenericScore genScore = CSDUtility.createSizedGenericScore(section.scoreText, BlueSystem.getString("csd.importedScore"));
        genScore.setStartTime(section.sectionStartTime);
        PolyObject pObj = (PolyObject)data.getScore().get(0);
        SoundLayer sLayer = pObj.newLayerAt(-1);
        sLayer.add(genScore);
    }

    private static void setSoundObjectsPerInstrument(BlueData data, ScoreSection section) {
        StringBuffer buffer;
        Integer iNum;
        TreeMap<Integer, StringBuffer> map = new TreeMap<Integer, StringBuffer>();
        StringTokenizer st = new StringTokenizer(section.scoreText, "\n");
        String line = "";
        Note previousNote = null;
        while (st.hasMoreTokens()) {
            line = st.nextToken();
            Note note = null;
            try {
                note = Note.createNote(line, previousNote);
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
            if (note == null) continue;
            iNum = new Integer(Integer.parseInt(note.getPField(1)));
            if (map.containsKey(iNum)) {
                buffer = (StringBuffer)map.get(iNum);
                buffer.append(line).append("\n");
            } else {
                buffer = new StringBuffer();
                buffer.append(line).append("\n");
                map.put(iNum, buffer);
            }
            previousNote = note;
        }
        for (Map.Entry entry : map.entrySet()) {
            NoteList notes;
            iNum = (Integer)entry.getKey();
            buffer = (StringBuffer)entry.getValue();
            if (buffer == null) continue;
            PolyObject pObj = (PolyObject)data.getScore().get(0);
            SoundLayer sLayer = pObj.newLayerAt(-1);
            String score = buffer.toString();
            try {
                notes = ScoreUtilities.getNotes(score);
            }
            catch (NoteParseException e) {
                throw new RuntimeException(e);
            }
            notes.sort();
            double minStart = ((Note)notes.get(0)).getStartTime();
            ScoreUtilities.normalizeNoteList(notes);
            GenericScore genScore = CSDUtility.createSizedGenericScore(notes.toString(), "Instrument " + iNum.toString());
            genScore.setStartTime(minStart + section.sectionStartTime);
            sLayer.add(genScore);
        }
    }

    private static GenericScore createSizedGenericScore(String noteText, String name) {
        GenericScore genScore = new GenericScore();
        genScore.setText(noteText);
        genScore.setSubjectiveDuration(genScore.getObjectiveDuration());
        genScore.setName(name);
        return genScore;
    }

    private static void parseCsOrc(BlueData data, String orc) {
        StringTokenizer st = new StringTokenizer(orc, "\n");
        String line = "";
        StringBuilder globalOrch = new StringBuilder();
        String sr = null;
        String kr = null;
        String ksmps = null;
        String instrIds = "";
        StringBuffer iBody = new StringBuffer();
        UserDefinedOpcode udo = null;
        GenericInstrument instr = null;
        Arrangement arrangement = data.getArrangement();
        OpcodeList opcodeList = data.getOpcodeList();
        int state = 0;
        while (st.hasMoreTokens()) {
            line = st.nextToken();
            String trimLine = line.trim();
            switch (state) {
                case 0: {
                    if (trimLine.startsWith("instr")) {
                        int index = line.indexOf(59);
                        String iName = "";
                        if (index != -1) {
                            iName = line.substring(index + 1).trim();
                            line = line.substring(0, index);
                        }
                        instrIds = line.substring(line.indexOf("instr") + 5).trim();
                        instr = new GenericInstrument();
                        instr.setName(iName);
                        state = 1;
                        break;
                    }
                    if (trimLine.startsWith("opcode")) {
                        String[] parts;
                        int index = line.indexOf(59);
                        if (index != -1) {
                            line = line.substring(0, index);
                        }
                        if ((parts = (line = line.substring(line.indexOf("opcode") + 6).trim()).split(",")).length != 3) {
                            System.err.println("Error parsing UDO: 3 args not found for definition");
                        } else {
                            udo = new UserDefinedOpcode();
                            udo.setOpcodeName(parts[0].trim());
                            udo.outTypes = parts[1].trim();
                            udo.inTypes = parts[2].trim();
                        }
                        state = 2;
                        break;
                    }
                    if (trimLine.startsWith("kr")) {
                        kr = line.substring(line.indexOf(61) + 1).trim();
                        break;
                    }
                    if (trimLine.startsWith("sr")) {
                        sr = line.substring(line.indexOf(61) + 1).trim();
                        break;
                    }
                    if (trimLine.startsWith("nchnls")) {
                        data.getProjectProperties().channels = line.substring(line.indexOf(61) + 1).trim();
                        break;
                    }
                    if (trimLine.startsWith("ksmps")) {
                        ksmps = line.substring(line.indexOf(61) + 1).trim();
                        break;
                    }
                    globalOrch.append(line).append("\n");
                    break;
                }
                case 1: {
                    if (trimLine.startsWith("endin")) {
                        if (instr != null && instrIds != null) {
                            instr.setText(iBody.toString());
                            if (instrIds.indexOf(44) > -1) {
                                String[] ids = instrIds.split(",");
                                for (int i = 0; i < ids.length; ++i) {
                                    arrangement.insertInstrument(ids[i], instr);
                                }
                            } else {
                                arrangement.insertInstrument(instrIds, instr);
                            }
                        }
                        instr = null;
                        instrIds = null;
                        iBody = new StringBuffer();
                        state = 0;
                        break;
                    }
                    if (instr == null) break;
                    iBody.append(line).append("\n");
                    break;
                }
                case 2: {
                    if (trimLine.startsWith("endop")) {
                        if (udo != null) {
                            udo.codeBody = iBody.toString();
                            opcodeList.addOpcode(udo);
                            iBody = new StringBuffer();
                            udo = null;
                        }
                        state = 0;
                        break;
                    }
                    if (udo == null) break;
                    iBody.append(line).append("\n");
                }
            }
        }
        if (kr != null && ksmps == null) {
            try {
                double krDouble = Double.parseDouble(kr);
                double srDouble = Double.parseDouble(sr);
                ksmps = Integer.toString((int)(srDouble / krDouble));
            }
            catch (NumberFormatException nfe) {
                ksmps = null;
            }
        }
        if (sr != null) {
            data.getProjectProperties().sampleRate = sr;
        }
        if (ksmps != null) {
            data.getProjectProperties().ksmps = ksmps;
        }
        data.getGlobalOrcSco().setGlobalOrc(globalOrch.toString());
    }

    public static void main(String[] args) {
        File test = new File("/work/blue/trappedInConvert/01-Trapped.csd");
        try {
            BufferedReader in = new BufferedReader(new FileReader(test));
            String line = "";
            StringBuilder buffer = new StringBuilder();
            while ((line = in.readLine()) != null) {
                buffer.append(line).append("\n");
            }
            String CSD = buffer.toString();
            BlueData data = CSDUtility.convertCSDtoBlue(CSD, 1);
            System.out.println(data.saveAsXML());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

