/*
 * Decompiled with CFR 0.152.
 */
package blue.utility;

import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Comment;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.utility.TextUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ScoreUtilities {
    private static int RAMP_END_NOT_FOUND = -1;
    private static int PFIELD_NOT_FLOAT = -2;

    /*
     * Unable to fully structure code
     */
    public static NoteList getNotes(String in) throws NoteParseException {
        notes = new NoteList();
        previousNote = null;
        start = -1;
        end = -1;
        lineNumber = 1;
        state = ParseState.STARTING;
        if (in == null || (len = in.length()) == 0) {
            return notes;
        }
        lastIndex = len - 1;
        block6: for (i = 0; i < len; ++i) {
            c = in.charAt(i);
            if (c == '\n') {
                ++lineNumber;
            }
            switch (2.$SwitchMap$blue$utility$ScoreUtilities$ParseState[state.ordinal()]) {
                case 1: {
                    if (c == ';') {
                        while (i < lastIndex && in.charAt(++i) != '\n') {
                        }
                        continue block6;
                    }
                    if (c == '/' && i < len - 2) {
                        if (in.charAt(i + 1) == '/') {
                            while (i < lastIndex && in.charAt(++i) != '\n') {
                            }
                            continue block6;
                        }
                        if (in.charAt(i + 1) != '*') continue block6;
                        while (i < lastIndex) {
                            if (in.charAt(++i) != '*' || i >= len - 2 || in.charAt(i + 1) != '/') continue;
                            ++i;
                            continue block6;
                        }
                        continue block6;
                    }
                    if (Character.isWhitespace(c)) continue block6;
                    state = ParseState.COLLECTING;
                    start = i;
                    continue block6;
                }
                case 2: {
                    if (c != ';') ** GOTO lbl39
                    end = --i;
                    ** GOTO lbl63
lbl39:
                    // 1 sources

                    if (c != '/' || i >= len - 2) ** GOTO lbl53
                    if (in.charAt(i + 1) != '/') ** GOTO lbl43
                    i = end = i - 1;
                    ** GOTO lbl63
lbl43:
                    // 1 sources

                    if (in.charAt(i + 1) != '*') ** GOTO lbl63
                    j = i;
                    while (j < lastIndex) {
                        if (in.charAt(++j) == '\n') {
                            end = --i;
                        }
                        if (in.charAt(j) != '*' || j >= len - 2 || in.charAt(j + 1) != '/') continue;
                        i = j + 1;
                        ** GOTO lbl63
                    }
                    ** GOTO lbl63
lbl53:
                    // 1 sources

                    if (c == '\n') {
                        if (i < lastIndex) {
                            c = in.charAt(i + 1);
                            if (Character.isDigit(c) || c == '\"' || c == '.') continue block6;
                            end = i;
                        } else {
                            end = i;
                        }
                    } else if (i == lastIndex) {
                        end = i;
                    }
lbl63:
                    // 10 sources

                    if (end <= 0) continue block6;
                    noteText = TextUtilities.stripMultiLineComments(in.substring(start, end + 1));
                    tempNote = null;
                    try {
                        if (noteText.charAt(0) == 'i') {
                            tempNote = Note.createNote(noteText, previousNote);
                        }
                    }
                    catch (NoteParseException e) {
                        e.setLineNumber(lineNumber);
                        throw e;
                    }
                    if (tempNote != null) {
                        notes.add(tempNote);
                        previousNote = tempNote;
                    }
                    state = ParseState.STARTING;
                    start = -1;
                    end = -1;
                }
            }
        }
        ScoreUtilities.expandPluses(notes);
        ScoreUtilities.expandRamps(notes);
        return notes;
    }

    private static void expandPluses(NoteList notes) {
        if (notes.size() < 2) {
            return;
        }
        Note previousNote = (Note)notes.get(0);
        for (int i = 1; i < notes.size(); ++i) {
            Note note = (Note)notes.get(i);
            if (note.getPField(2).equals("+")) {
                note.setPField(Double.toString(previousNote.getStartTime() + previousNote.getSubjectiveDuration()), 2);
            }
            previousNote = note;
        }
    }

    public static void expandRamps(NoteList nl) {
        for (int i = 0; i < nl.size(); ++i) {
            Note currentNote = (Note)nl.get(i);
            for (int j = 0; j < currentNote.getPCount(); ++j) {
                String pField = currentNote.getPField(j + 1);
                if (!pField.equals(">") && !pField.equals("<")) continue;
                int headNoteIndex = ScoreUtilities.findRampHead(nl, i, j + 1);
                int tailNoteIndex = ScoreUtilities.findRampTail(nl, i, j + 1);
                if (headNoteIndex < 0 || tailNoteIndex < 0) {
                    System.err.println("Error finding ramp end");
                    continue;
                }
                Note startNote = (Note)nl.get(headNoteIndex);
                Note endNote = (Note)nl.get(tailNoteIndex);
                double b = Double.parseDouble(startNote.getPField(j + 1));
                double rise = Double.parseDouble(endNote.getPField(j + 1)) - Double.parseDouble(startNote.getPField(j + 1));
                double run = endNote.getStartTime() - startNote.getStartTime();
                double m = rise / run;
                for (int k = headNoteIndex + 1; k < tailNoteIndex; ++k) {
                    Note tempNote = (Note)nl.get(k);
                    double x = tempNote.getStartTime() - startNote.getStartTime();
                    double newVal = m * x + b;
                    tempNote.setPField(Double.toString(newVal), j + 1);
                }
            }
        }
    }

    private static int findRampHead(NoteList nl, int currentNoteIndex, int pFieldNum) {
        String pField;
        int previousNoteIndex = currentNoteIndex - 1;
        if (previousNoteIndex < 0) {
            return RAMP_END_NOT_FOUND;
        }
        try {
            pField = ((Note)nl.get(previousNoteIndex)).getPField(pFieldNum);
        }
        catch (IndexOutOfBoundsException iobe) {
            return RAMP_END_NOT_FOUND;
        }
        if (pField.equals(">") || pField.equals("<")) {
            return ScoreUtilities.findRampHead(nl, previousNoteIndex, pFieldNum);
        }
        try {
            Double.parseDouble(pField);
        }
        catch (NumberFormatException nfe) {
            return PFIELD_NOT_FLOAT;
        }
        return previousNoteIndex;
    }

    private static int findRampTail(NoteList nl, int currentNoteIndex, int pFieldNum) {
        String pField;
        int nextNote = currentNoteIndex + 1;
        if (nextNote >= nl.size()) {
            return RAMP_END_NOT_FOUND;
        }
        try {
            pField = ((Note)nl.get(nextNote)).getPField(pFieldNum);
        }
        catch (IndexOutOfBoundsException iobe) {
            return RAMP_END_NOT_FOUND;
        }
        if (pField.equals(">") || pField.equals("<")) {
            return ScoreUtilities.findRampTail(nl, nextNote, pFieldNum);
        }
        try {
            Double.parseDouble(pField);
        }
        catch (NumberFormatException nfe) {
            return PFIELD_NOT_FLOAT;
        }
        return nextNote;
    }

    public static double getTotalDuration(NoteList notes) {
        int size = notes.size();
        double max = 0.0;
        for (int i = 0; i < size; ++i) {
            Note tempNote = (Note)notes.get(i);
            double tempValue = tempNote.getStartTime() + tempNote.getObjectiveDuration();
            if (!(max < tempValue)) continue;
            max = tempValue;
        }
        return max;
    }

    public static double getProcessingStartTime(PolyObject pObj) {
        List<SoundObject> sObjects = pObj.getSoundObjects(false);
        Collections.sort(sObjects, new Comparator<SoundObject>(){

            @Override
            public int compare(SoundObject s1, SoundObject s2) {
                return (int)(s1.getStartTime() - s2.getStartTime());
            }
        });
        double time = Double.MAX_VALUE;
        for (int i = 0; i < sObjects.size(); ++i) {
            SoundObject sObj = sObjects.get(i);
            String className = sObj.getClass().getName();
            if (className.equals("blue.soundObject.FrozenSoundObject") || className.equals("blue.soundObject.Comment") || !(sObj.getStartTime() < time)) continue;
            time = sObj.getStartTime();
        }
        if (time == Double.MAX_VALUE) {
            time = 0.0;
        }
        return time;
    }

    public static void scaleScore(NoteList notes, double multiplier) {
        for (int i = 0; i < notes.size(); ++i) {
            Note tempNote = (Note)notes.get(i);
            tempNote.setStartTime(tempNote.getStartTime() * multiplier);
            tempNote.setSubjectiveDuration(tempNote.getObjectiveDuration() * multiplier);
        }
    }

    public static void setScoreStart(NoteList notes, double start) {
        for (int i = 0; i < notes.size(); ++i) {
            ((Note)notes.get(i)).setStartTime(((Note)notes.get(i)).getStartTime() + start);
        }
    }

    public static void normalizeNoteList(NoteList notes) {
        notes.sort();
        double minStart = ((Note)notes.get(0)).getStartTime();
        for (int i = 0; i < notes.size(); ++i) {
            Note temp = (Note)notes.get(i);
            temp.setStartTime(temp.getStartTime() - minStart);
        }
    }

    public static void applyNoteProcessorChain(NoteList notes, NoteProcessorChain npc) throws NoteProcessorException {
        for (int i = 0; i < npc.size(); ++i) {
            NoteProcessor np = (NoteProcessor)npc.get(i);
            np.processNotes(notes);
        }
    }

    public static void applyTimeBehavior(NoteList notes, int timeBehavior, double subjectiveDuration, double repeatPoint) {
        ScoreUtilities.applyTimeBehavior(notes, timeBehavior, subjectiveDuration, repeatPoint, -1.0);
    }

    public static void applyTimeBehavior(NoteList notes, int timeBehavior, double subjectiveDuration, double repeatPoint, double durationForScale) {
        if (notes.size() == 0) {
            return;
        }
        if (timeBehavior == 0) {
            double dur = durationForScale;
            if (durationForScale < 0.0) {
                dur = ScoreUtilities.getTotalDuration(notes);
            }
            double multiplier = subjectiveDuration / dur;
            ScoreUtilities.scaleScore(notes, multiplier);
        } else if (timeBehavior == 1) {
            NoteList originalNotes = new NoteList(notes);
            originalNotes.sort();
            double objDur = durationForScale;
            if (durationForScale < 0.0) {
                objDur = ScoreUtilities.getTotalDuration(originalNotes);
            }
            double repeatDur = objDur;
            if (objDur > 0.0 && repeatPoint > 0.0) {
                repeatDur = repeatPoint;
            }
            double startVal = 0.0;
            NoteList tempNL = null;
            if (repeatDur <= 0.0) {
                return;
            }
            notes.clear();
            while (startVal + repeatDur < subjectiveDuration) {
                tempNL = new NoteList(originalNotes);
                ScoreUtilities.setScoreStart(tempNL, startVal);
                notes.merge(tempNL);
                startVal += repeatDur;
            }
            tempNL = new NoteList(originalNotes);
            Note tempNote = null;
            double remainingDur = subjectiveDuration - startVal;
            for (int i = 0; i < tempNL.size() && (tempNote = new Note((Note)tempNL.get(i))).getStartTime() + tempNote.getSubjectiveDuration() <= remainingDur; ++i) {
                tempNote.setStartTime(tempNote.getStartTime() + startVal);
                notes.add(tempNote);
            }
        } else if (timeBehavior == 2) {
            return;
        }
    }

    public static double getMaxTime(SoundObject[] sObjects) {
        double max = 0.0;
        for (int i = 0; i < sObjects.length; ++i) {
            double val = sObjects[i].getStartTime() + sObjects[i].getSubjectiveDuration();
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static double getMaxTime(List<SoundObject> sObjects) {
        double max = 0.0;
        int size = sObjects.size();
        for (int i = 0; i < size; ++i) {
            SoundObject sObj = sObjects.get(i);
            double val = sObj.getStartTime() + sObj.getSubjectiveDuration();
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static double getMaxTimeWithEmptyCheck(List<SoundObject> sObjects) {
        double max = 0.0;
        int size = sObjects.size();
        for (int i = 0; i < size; ++i) {
            double val;
            PolyObject pObj;
            SoundObject sObj = sObjects.get(i);
            if (sObj instanceof Comment || sObj instanceof PolyObject && (pObj = (PolyObject)sObj).isScoreGenerationEmpty() || !((val = sObj.getStartTime() + sObj.getSubjectiveDuration()) > max)) continue;
            max = val;
        }
        return max;
    }

    public static double getMinTime(SoundObject[] sObjects) {
        double min = ScoreUtilities.getMaxTime(sObjects);
        for (int i = 0; i < sObjects.length; ++i) {
            double val = sObjects[i].getStartTime();
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static double getMinTime(ArrayList sObjects) {
        double min = ScoreUtilities.getMaxTime(sObjects);
        int size = sObjects.size();
        for (int i = 0; i < size; ++i) {
            SoundObject sObj = (SoundObject)sObjects.get(i);
            double val = sObj.getStartTime();
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static String testNotesList(NoteList nl) {
        StringBuilder returnText = new StringBuilder();
        for (int i = 0; i < nl.size(); ++i) {
            returnText.append("N").append(i).append(": s>").append(((Note)nl.get(i)).getStartTime()).append(" d>").append(((Note)nl.get(i)).getSubjectiveDuration()).append("\n");
        }
        return returnText.toString();
    }

    public static double getBaseTen(String pch) {
        double pitch;
        int octave;
        int index = pch.indexOf(46);
        if (index == -1) {
            octave = Integer.parseInt(pch);
            pitch = 0.0;
        } else if (index == 0 || index == pch.length() - 1) {
            octave = Integer.parseInt("0" + pch.substring(0, index));
            pitch = Double.parseDouble("0" + pch.substring(index));
        } else {
            octave = Integer.parseInt(pch.substring(0, index));
            pitch = Double.parseDouble(pch.substring(index));
        }
        return (double)(octave * 12) + (pitch *= 100.0);
    }

    public static double getSnapValueStart(double time, double snapValue) {
        return (double)((int)(time / snapValue)) * snapValue;
    }

    public static double getSnapValueMove(double time, double snapValue) {
        return (double)Math.round(time / snapValue) * snapValue;
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        try {
            n.add(Note.createNote("i1 0 2 3 0"));
            for (int i = 0; i < 10; ++i) {
                n.add(Note.createNote("i1 " + (2 + i * 2) + " 2 3 <"));
            }
            n.add(Note.createNote("i1 22 2 3 4"));
        }
        catch (NoteParseException npe) {
            npe.printStackTrace();
        }
        System.out.println("before: \n\n" + n + "\n\n");
        ScoreUtilities.expandRamps(n);
        System.out.println("after: \n\n" + n + "\n\n");
    }

    static enum ParseState {
        STARTING,
        COLLECTING;

    }
}

