/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import blue.ui.utilities.UiUtilities;
import blue.utility.GUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class HandGrabberMouseListener
implements MouseListener,
MouseMotionListener {
    private JScrollPane jsp;
    int startX = 0;
    int startY = 0;
    Point viewPoint = null;
    Point newPoint = new Point();
    int scrollStartX = 0;
    int scrollStartY = 0;
    boolean isWorking = false;

    public HandGrabberMouseListener(JScrollPane jsp) {
        this.jsp = jsp;
        jsp.getViewport().getView().addMouseListener(this);
        jsp.getViewport().getView().addMouseMotionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (UiUtilities.isRightMouseButton((MouseEvent)e) && e.isShiftDown()) {
            this.isWorking = true;
            this.jsp.getViewport().getView().setCursor(Cursor.getPredefinedCursor(13));
            this.startX = e.getX();
            this.startY = e.getY();
            this.scrollStartX = this.jsp.getHorizontalScrollBar().getValue();
            this.scrollStartY = this.jsp.getVerticalScrollBar().getValue();
            this.viewPoint = this.jsp.getViewport().getViewPosition();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isWorking) {
            this.jsp.getViewport().getView().setCursor(Cursor.getDefaultCursor());
        }
        this.isWorking = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isWorking) {
            int diffX = this.startX - e.getX();
            int diffY = this.startY - e.getY();
            int maxX = this.jsp.getHorizontalScrollBar().getMaximum();
            int maxY = this.jsp.getVerticalScrollBar().getMaximum();
            int newX = this.scrollStartX + diffX;
            int newY = this.scrollStartY + diffY;
            if (newX < 0) {
                newX = 0;
            }
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY < 0) {
                newY = 0;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            int tempX = newX;
            int tempY = newY;
            SwingUtilities.invokeLater(() -> {
                this.jsp.getHorizontalScrollBar().setValue(tempX);
                this.jsp.getVerticalScrollBar().setValue(tempY);
            });
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                int i;
                super.paintComponent(g);
                g.setColor(Color.BLACK);
                int h = this.getHeight();
                int w = this.getWidth();
                g.fillRect(0, 0, w, h);
                g.setColor(Color.DARK_GRAY);
                for (i = 0; i < h; i += 10) {
                    g.drawLine(0, i, w, i);
                }
                for (i = 0; i < w; i += 10) {
                    g.drawLine(i, 0, i, h);
                }
            }
        };
        panel.setSize(10000, 10000);
        panel.setPreferredSize(new Dimension(1000, 1000));
        JScrollPane jsp = new JScrollPane(panel);
        new HandGrabberMouseListener(jsp);
        GUI.showComponentAsStandalone((Component)jsp, (String)"Hand Grabber Test", (boolean)true);
    }
}

