/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder;

import blue.BlueSystem;
import blue.WindowSettingManager;
import blue.WindowSettingsSavable;
import blue.orchestra.blueSynthBuilder.BSBDropdownItem;
import blue.orchestra.editor.blueSynthBuilder.DropdownItemsTableModel;
import blue.utility.GUI;
import electric.xml.Element;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javafx.collections.ObservableList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class DropdownItemEditorDialog
extends JDialog
implements WindowSettingsSavable {
    ObservableList<BSBDropdownItem> items = null;
    DropdownItemsTableModel model = new DropdownItemsTableModel();
    JTable table;

    public DropdownItemEditorDialog() {
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(1, 4));
        JButton addButton = new JButton();
        JButton pushDownButton = new JButton();
        JButton pushUpButton = new JButton();
        JButton removeButton = new JButton();
        addButton.setText(BlueSystem.getString((String)"common.add"));
        removeButton.setText(BlueSystem.getString((String)"common.remove"));
        pushUpButton.setText(BlueSystem.getString((String)"common.pushUp"));
        pushDownButton.setText(BlueSystem.getString((String)"common.pushDown"));
        addButton.addActionListener(e -> this.addItem());
        removeButton.addActionListener(e -> this.removeItem());
        pushUpButton.addActionListener(e -> this.pushUpItem());
        pushDownButton.addActionListener(e -> this.pushDownItem());
        topPanel.add(addButton);
        topPanel.add(removeButton);
        topPanel.add(pushUpButton);
        topPanel.add(pushDownButton);
        this.table = new JTable(this.model);
        JScrollPane scrollPane = new JScrollPane(this.table);
        FlowLayout flowLayout = new FlowLayout(1);
        JPanel closePanel = new JPanel(flowLayout);
        JButton closeButton = new JButton(BlueSystem.getString((String)"menu.file.close.text"));
        closeButton.addActionListener(e -> this.closeDialog());
        closePanel.add(closeButton);
        this.getContentPane().add((Component)topPanel, "North");
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)closePanel, "South");
        this.setSize(400, 300);
        WindowSettingManager.getInstance().registerWindow("DropdownItemEditorDialog", this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (DropdownItemEditorDialog.this.table.getCellEditor() != null) {
                    DropdownItemEditorDialog.this.table.getCellEditor().stopCellEditing();
                }
            }
        });
    }

    protected void closeDialog() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.dispose();
    }

    void addItem() {
        this.model.addDropdownItem();
    }

    void removeItem() {
        this.model.removeDropdownItem(this.table.getSelectedRow());
        this.table.clearSelection();
    }

    void pushUpItem() {
        this.model.pushUpItem(this.table.getSelectedRow());
        if (this.table.getSelectedRow() > 0) {
            this.table.setRowSelectionInterval(this.table.getSelectedRow() - 1, this.table.getSelectedRow() - 1);
        }
    }

    void pushDownItem() {
        this.model.pushDownItem(this.table.getSelectedRow());
        if (this.table.getSelectedRow() < this.items.size() - 1) {
            this.table.setRowSelectionInterval(this.table.getSelectedRow() + 1, this.table.getSelectedRow() + 1);
        }
    }

    public void show(ObservableList<BSBDropdownItem> items) {
        this.items = items;
        GUI.centerOnScreen((Component)this);
        this.model.setDropdownItems(items);
        super.setVisible(true);
    }

    @Override
    public void loadWindowSettings(Element settings) {
        WindowSettingManager.setBasicSettings(settings, this);
    }

    @Override
    public Element saveWindowSettings() {
        return WindowSettingManager.getBasicSettings(this);
    }
}

