/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.Preset;
import blue.orchestra.blueSynthBuilder.PresetGroup;
import blue.orchestra.editor.blueSynthBuilder.PresetsTreeModel;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class PresetsTreeDropTarget
implements DropTargetListener {
    DropTarget target;
    JTree targetTree;

    public PresetsTreeDropTarget(JTree tree) {
        this.targetTree = tree;
        this.target = new DropTarget(this.targetTree, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath path = tree.getClosestPathForLocation(p.x, p.y);
        if (path.getLastPathComponent() instanceof PresetGroup) {
            dtde.acceptDrag(dtde.getSourceActions());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.dragEnter(dtde);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point pt = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath parentpath = tree.getClosestPathForLocation(pt.x, pt.y);
        Object node = parentpath.getLastPathComponent();
        if (!(node instanceof PresetGroup)) {
            dtde.rejectDrop();
            return;
        }
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!tr.isDataFlavorSupported(flavors[i])) continue;
                dtde.acceptDrop(dtde.getDropAction());
                Object transferNode = tr.getTransferData(flavors[i]);
                PresetsTreeModel presetsTreeModel = (PresetsTreeModel)tree.getModel();
                PresetGroup parentNode = (PresetGroup)node;
                if (transferNode instanceof Preset) {
                    Preset preset = (Preset)transferNode;
                    presetsTreeModel.addPreset(parentNode, preset);
                    dtde.dropComplete(true);
                } else if (transferNode instanceof PresetGroup) {
                    PresetGroup presetGroup = (PresetGroup)transferNode;
                    presetsTreeModel.addPresetGroup(parentNode, presetGroup);
                    dtde.dropComplete(true);
                } else {
                    dtde.rejectDrop();
                }
                return;
            }
            dtde.rejectDrop();
        }
        catch (UnsupportedFlavorException | IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }
}

